/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.ex.FileSystemTreeImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xml.config.ConfigFileSearcher;
import com.intellij.xml.config.ConfigFilesTreeBuilder;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlNamespaceIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import com.intellij.xml.util.XmlUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MapExternalResourceDialog
extends DialogWrapper {
    private static final String MAP_EXTERNAL_RESOURCE_SELECTED_TAB = "map.external.resource.selected.tab";
    private JTextField myUri;
    private JPanel myMainPanel;
    private JTree mySchemasTree;
    private JPanel myExplorerPanel;
    private JBTabbedPane myTabs;
    private final FileSystemTreeImpl myExplorer;
    private String myLocation;

    public MapExternalResourceDialog(String uri, @Nullable Project project2, @Nullable PsiFile file2, @Nullable String location) {
        super(project2);
        this.$$$setupUI$$$();
        this.setTitle("Map External Resource");
        this.myUri.setText(uri);
        this.myUri.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                MapExternalResourceDialog.this.validateInput();
            }
        });
        this.myExplorer = new FileSystemTreeImpl(project2, new FileChooserDescriptor(true, false, false, false, true, false));
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myExplorer);
        this.myExplorer.addListener(new FileSystemTree.Listener(){

            public void selectionChanged(List<VirtualFile> selection) {
                MapExternalResourceDialog.this.validateInput();
            }
        }, (Disposable)this.myExplorer);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1 && MapExternalResourceDialog.this.isOKActionEnabled()) {
                    MapExternalResourceDialog.this.doOKAction();
                }
            }
        };
        this.myExplorer.getTree().addMouseListener(mouseAdapter);
        this.myExplorerPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myExplorer.getTree()), "Center");
        AnAction actionGroup = ActionManager.getInstance().getAction("FileChooserToolbar");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, true);
        toolbar.setTargetComponent((JComponent)this.myExplorerPanel);
        this.myExplorerPanel.add((Component)toolbar.getComponent(), "North");
        if (project2 != null) {
            this.setupSchemasTab(uri, project2, file2, location, mouseAdapter);
        } else {
            this.myTabs.removeTabAt(0);
        }
        this.init();
    }

    private void setupSchemasTab(String uri, @NotNull Project project2, @Nullable PsiFile file2, @Nullable String location, MouseAdapter mouseAdapter) {
        VirtualFile virtualFile;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/MapExternalResourceDialog", "setupSchemasTab"));
        }
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.mySchemasTree.setModel(new DefaultTreeModel(root));
        ConfigFileSearcher searcher = new ConfigFileSearcher(file2 == null ? null : ModuleUtilCore.findModuleForPsiElement((PsiElement)file2), project2){

            @Override
            public Set<PsiFile> search(@Nullable Module module2, @NotNull Project project2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/MapExternalResourceDialog$4", "search"));
                }
                List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = XmlNamespaceIndex.getAllResources(module2, project2, null);
                HashSet<PsiFile> files = new HashSet<PsiFile>();
                PsiManager psiManager = PsiManager.getInstance((Project)project2);
                for (IndexedRelevantResource<String, XsdNamespaceBuilder> resource : resources) {
                    VirtualFile file2 = resource.getFile();
                    PsiFile psiFile = psiManager.findFile(file2);
                    ContainerUtil.addIfNotNull(files, (Object)psiFile);
                }
                return files;
            }
        };
        searcher.search();
        new ConfigFilesTreeBuilder(this.mySchemasTree).buildTree(root, searcher);
        TreeUtil.expandAll((JTree)this.mySchemasTree);
        this.mySchemasTree.setRootVisible(false);
        this.mySchemasTree.setShowsRootHandles(true);
        ColoredTreeCellRenderer renderer = new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javaee/MapExternalResourceDialog$5", "customizeCellRenderer"));
                }
                ConfigFilesTreeBuilder.renderNode(value, expanded, this);
            }
        };
        renderer.setFont(EditorColorsManager.getInstance().getGlobalScheme().getFont(EditorFontType.PLAIN));
        this.mySchemasTree.setCellRenderer((TreeCellRenderer)renderer);
        this.mySchemasTree.addMouseListener(mouseAdapter);
        this.mySchemasTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MapExternalResourceDialog.this.validateInput();
            }
        });
        XmlFile schema = null;
        if (file2 != null) {
            schema = XmlUtil.findNamespaceByLocation(file2, uri);
        } else if (location != null && (virtualFile = VfsUtilCore.findRelativeFile((String)location, null)) != null) {
            schema = PsiManager.getInstance((Project)project2).findFile(virtualFile);
        }
        if (schema != null) {
            DefaultMutableTreeNode node = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)root, (Object)schema);
            if (node != null) {
                TreeUtil.selectNode((JTree)this.mySchemasTree, (TreeNode)node);
            }
            this.myExplorer.select(schema.getVirtualFile(), null);
        }
        int index = PropertiesComponent.getInstance().getInt(MAP_EXTERNAL_RESOURCE_SELECTED_TAB, 0);
        this.myTabs.setSelectedIndex(index);
        this.myTabs.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PropertiesComponent.getInstance().setValue(MapExternalResourceDialog.MAP_EXTERNAL_RESOURCE_SELECTED_TAB, Integer.toString(MapExternalResourceDialog.this.myTabs.getSelectedIndex()));
            }
        });
    }

    protected void processDoNotAskOnOk(int exitCode) {
        super.processDoNotAskOnOk(exitCode);
        this.myLocation = this.getResourceLocation();
    }

    private void validateInput() {
        this.setOKActionEnabled(!StringUtil.isEmpty((String)this.myUri.getText()) && this.getResourceLocation() != null);
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return StringUtil.isEmpty((String)this.myUri.getText()) ? this.myUri : this.mySchemasTree;
    }

    public String getUri() {
        return this.myUri.getText();
    }

    @Nullable
    public String getResourceLocation() {
        if (this.myLocation != null) {
            return this.myLocation;
        }
        if (this.myTabs.getTabCount() > 1 && this.myTabs.getSelectedIndex() == 0) {
            TreePath path = this.mySchemasTree.getSelectionPath();
            if (path == null) {
                return null;
            }
            Object object = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
            if (!(object instanceof PsiFile)) {
                return null;
            }
            return FileUtil.toSystemIndependentName((String)((PsiFile)object).getVirtualFile().getPath());
        }
        VirtualFile file2 = this.myExplorer.getSelectedFile();
        return file2 == null ? null : FileUtil.toSystemIndependentName((String)file2.getPath());
    }

    private void createUIComponents() {
        this.myExplorerPanel = new JPanel(new BorderLayout());
        DataManager.registerDataProvider((JComponent)this.myExplorerPanel, (DataProvider)new DataProvider(){

            @Nullable
            public Object getData(@NonNls String dataId) {
                if (CommonDataKeys.VIRTUAL_FILE_ARRAY.is(dataId)) {
                    return MapExternalResourceDialog.this.myExplorer.getSelectedFiles();
                }
                if (FileSystemTree.DATA_KEY.is(dataId)) {
                    return MapExternalResourceDialog.this.myExplorer;
                }
                return null;
            }
        });
    }

    @Nullable
    protected String getHelpId() {
        return "Map External Resource dialog";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTabbedPane jBTabbedPane;
        JTextField jTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("URI:");
        jBLabel.setDisplayedMnemonic('U');
        jBLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myUri = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myTabs = jBTabbedPane = new JBTabbedPane();
        jPanel2.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Schemas", null, jPanel3, null);
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Tree tree = new Tree();
        this.mySchemasTree = tree;
        jBScrollPane.setViewportView((Component)tree);
        JPanel jPanel4 = this.myExplorerPanel;
        jBTabbedPane.addTab("Explorer", null, jPanel4, null);
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

