/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.mock.MockProjectEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockPsiElement
extends UserDataHolderBase
implements PsiElement,
Navigatable {
    private final String myText;
    private final Project myProject;
    private final List<PsiElement> myDeclarations;
    private Ref<PsiElement> myParent;
    private PsiManager myManager;

    public MockPsiElement(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/mock/MockPsiElement", "<init>"));
        }
        this(null, new MockProjectEx(parentDisposable));
    }

    private MockPsiElement(String text, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/mock/MockPsiElement", "<init>"));
        }
        this.myDeclarations = new SmartList();
        this.myText = text;
        this.myProject = project2;
    }

    public void navigate(boolean requestFocus) {
        throw new UnsupportedOperationException("Method navigate is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public boolean canNavigate() {
        throw new UnsupportedOperationException("Method canNavigate is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public boolean canNavigateToSource() {
        throw new UnsupportedOperationException("Method canNavigateToSource is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public List<PsiElement> getDeclarations() {
        return this.myDeclarations;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/mock/MockPsiElement", "accept"));
        }
        throw new UnsupportedOperationException("Method accept is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public void acceptChildren(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/mock/MockPsiElement", "acceptChildren"));
        }
        throw new UnsupportedOperationException("Method acceptChildren is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/mock/MockPsiElement", "add"));
        }
        throw new UnsupportedOperationException("Method add is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/mock/MockPsiElement", "addAfter"));
        }
        throw new UnsupportedOperationException("Method addAfter is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/mock/MockPsiElement", "addBefore"));
        }
        throw new UnsupportedOperationException("Method addBefore is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public PsiElement addRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new UnsupportedOperationException("Method addRange is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public PsiElement addRangeAfter(PsiElement first, PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        throw new UnsupportedOperationException("Method addRangeAfter is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public PsiElement addRangeBefore(@NotNull PsiElement first, @NotNull PsiElement last, PsiElement anchor) throws IncorrectOperationException {
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/mock/MockPsiElement", "addRangeBefore"));
        }
        if (last == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "last", "com/intellij/mock/MockPsiElement", "addRangeBefore"));
        }
        throw new UnsupportedOperationException("Method addRangeBefore is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public void checkAdd(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/mock/MockPsiElement", "checkAdd"));
        }
        throw new UnsupportedOperationException("Method checkAdd is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public void checkDelete() throws IncorrectOperationException {
        throw new UnsupportedOperationException("Method checkDelete is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public PsiElement copy() {
        throw new UnsupportedOperationException("Method copy is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public void delete() throws IncorrectOperationException {
        throw new UnsupportedOperationException("Method delete is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public void deleteChildRange(PsiElement first, PsiElement last) throws IncorrectOperationException {
        throw new UnsupportedOperationException("Method deleteChildRange is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Nullable
    public PsiElement findElementAt(int offset) {
        throw new UnsupportedOperationException("Method findElementAt is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Nullable
    public PsiReference findReferenceAt(int offset) {
        throw new UnsupportedOperationException("Method findReferenceAt is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public PsiElement[] getChildren() {
        throw new UnsupportedOperationException("Method getChildren is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public PsiFile getContainingFile() throws PsiInvalidElementAccessException {
        throw new UnsupportedOperationException("Method getContainingFile is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Nullable
    public PsiElement getContext() {
        return this.getParent();
    }

    @Nullable
    public <T> T getCopyableUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/mock/MockPsiElement", "getCopyableUserData"));
        }
        throw new UnsupportedOperationException("Method getCopyableUserData is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Nullable
    public PsiElement getFirstChild() {
        throw new UnsupportedOperationException("Method getFirstChild is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public Language getLanguage() {
        throw new UnsupportedOperationException("Method getLanguage is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Nullable
    public PsiElement getLastChild() {
        throw new UnsupportedOperationException("Method getLastChild is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public PsiManager getManager() {
        return this.myManager;
    }

    public void setManager(PsiManager manager) {
        this.myManager = manager;
    }

    public PsiElement getNavigationElement() {
        throw new UnsupportedOperationException("Method getNavigationElement is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Nullable
    public PsiElement getNextSibling() {
        throw new UnsupportedOperationException("Method getNextSibling is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Nullable
    public ASTNode getNode() {
        throw new UnsupportedOperationException("Method getNode is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public PsiElement getOriginalElement() {
        throw new UnsupportedOperationException("Method getOriginalElement is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public void setParent(PsiElement parent) {
        this.myParent = Ref.create((Object)parent);
    }

    public PsiElement getParent() {
        if (this.myParent == null) {
            throw new UnsupportedOperationException("Method getParent is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
        }
        return (PsiElement)this.myParent.get();
    }

    @Nullable
    public PsiElement getPrevSibling() {
        throw new UnsupportedOperationException("Method getPrevSibling is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/mock/MockPsiElement", "getProject"));
        }
        return project2;
    }

    @Nullable
    public PsiReference getReference() {
        throw new UnsupportedOperationException("Method getReference is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public PsiReference[] getReferences() {
        throw new UnsupportedOperationException("Method getReferences is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public GlobalSearchScope getResolveScope() {
        throw new UnsupportedOperationException("Method getResolveScope is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public int getStartOffsetInParent() {
        throw new UnsupportedOperationException("Method getStartOffsetInParent is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NonNls
    public String getText() {
        return this.myText;
    }

    public int getTextLength() {
        return this.myText.length();
    }

    public int getTextOffset() {
        return this.getTextRange().getStartOffset();
    }

    public TextRange getTextRange() {
        throw new UnsupportedOperationException("Method getTextRange is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public SearchScope getUseScope() {
        throw new UnsupportedOperationException("Method getUseScope is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public boolean isPhysical() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public boolean isWritable() {
        throw new UnsupportedOperationException("Method isWritable is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @Nullable
    protected <T extends PsiNamedElement> T findDeclaration(String name, Class<T> aClass) {
        for (PsiElement declaration : this.myDeclarations) {
            PsiNamedElement psiNamedElement;
            if (!(declaration instanceof PsiNamedElement) || !name.equals((psiNamedElement = (PsiNamedElement)declaration).getName()) || !aClass.isInstance(psiNamedElement)) continue;
            return (T)psiNamedElement;
        }
        return null;
    }

    public void addDeclaration(PsiElement declaration) {
        if (this.myDeclarations.contains(declaration)) {
            this.myDeclarations.remove(declaration);
        } else if (declaration instanceof PsiNamedElement) {
            this.myDeclarations.remove(this.findDeclaration(((PsiNamedElement)declaration).getName(), ((PsiNamedElement)declaration).getClass()));
        }
        this.myDeclarations.add(declaration);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/mock/MockPsiElement", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/mock/MockPsiElement", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/mock/MockPsiElement", "processDeclarations"));
        }
        for (PsiElement declaration : this.myDeclarations) {
            if (processor2.execute(declaration, state)) continue;
            return false;
        }
        return true;
    }

    public <T> void putCopyableUserData(@NotNull Key<T> key2, T value) {
        if (key2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/mock/MockPsiElement", "putCopyableUserData"));
        }
        throw new UnsupportedOperationException("Method putCopyableUserData is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public PsiElement replace(@NotNull PsiElement newElement) throws IncorrectOperationException {
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/intellij/mock/MockPsiElement", "replace"));
        }
        throw new UnsupportedOperationException("Method replace is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public boolean textContains(char c) {
        throw new UnsupportedOperationException("Method textContains is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public boolean textMatches(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/mock/MockPsiElement", "textMatches"));
        }
        throw new UnsupportedOperationException("Method textMatches is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public boolean textMatches(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/mock/MockPsiElement", "textMatches"));
        }
        throw new UnsupportedOperationException("Method textMatches is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    public char[] textToCharArray() {
        throw new UnsupportedOperationException("Method textToCharArray is not yet implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    public Icon getIcon(int flags) {
        return null;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return this == another;
    }
}

