/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

public class PermanentInstallationID {
    private static final String OLD_USER_ON_MACHINE_ID_KEY = "JetBrains.UserIdOnMachine";
    private static final String INSTALLATION_ID_KEY = "user_id_on_machine";
    private static final String INSTALLATION_ID = PermanentInstallationID.calculateInstallationId();

    public static String get() {
        return INSTALLATION_ID;
    }

    private static String calculateInstallationId() {
        File dir;
        String appdata;
        Preferences oldPrefs = Preferences.userRoot();
        String oldValue = oldPrefs.get(OLD_USER_ON_MACHINE_ID_KEY, null);
        Preferences prefs = Preferences.userRoot().node("jetbrains");
        String installationId = prefs.get(INSTALLATION_ID_KEY, null);
        if (installationId == null || installationId.isEmpty()) {
            installationId = oldValue != null && !oldValue.isEmpty() ? oldValue : UUID.randomUUID().toString();
            prefs.put(INSTALLATION_ID_KEY, installationId);
        }
        if (SystemInfo.isWindows && (appdata = System.getenv("APPDATA")) != null && ((dir = new File(appdata, "JetBrains")).exists() || dir.mkdirs())) {
            File permanentIdFile = new File(dir, "PermanentUserId");
            try {
                String fromFile = "";
                if (permanentIdFile.exists()) {
                    fromFile = PermanentInstallationID.loadFromFile(permanentIdFile).trim();
                }
                if (!fromFile.isEmpty()) {
                    if (!fromFile.equals(installationId)) {
                        installationId = fromFile;
                        prefs.put(INSTALLATION_ID_KEY, installationId);
                    }
                } else {
                    PermanentInstallationID.writeToFile(permanentIdFile, installationId);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!installationId.equals(oldValue)) {
            oldPrefs.put(OLD_USER_ON_MACHINE_ID_KEY, installationId);
        }
        return installationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static String loadFromFile(@NotNull File file2) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/application/PermanentInstallationID", "loadFromFile"));
        }
        FileInputStream is = new FileInputStream(file2);
        byte[] bytes = FileUtilRt.loadBytes((InputStream)is);
        int offset = CharsetToolkit.hasUTF8Bom((byte[])bytes) ? CharsetToolkit.UTF8_BOM.length : 0;
        String string = new String(bytes, offset, bytes.length - offset, CharsetToolkit.UTF8_CHARSET);
        String string2 = string;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/PermanentInstallationID", "loadFromFile"));
        }
        return string2;
        finally {
            is.close();
        }
    }

    private static void writeToFile(@NotNull File file2, @NotNull String text) throws IOException {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/application/PermanentInstallationID", "writeToFile"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/application/PermanentInstallationID", "writeToFile"));
        }
        try (DataOutputStream stream = new DataOutputStream(new FileOutputStream(file2));){
            stream.write(text.getBytes(CharsetToolkit.UTF8_CHARSET));
        }
    }
}

