/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.apply;

import com.intellij.openapi.diff.impl.patch.ApplyPatchException;
import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import java.util.ArrayList;
import java.util.List;

public class ApplyPatchHunk {
    private final PatchHunk myHunk;

    public ApplyPatchHunk(PatchHunk hunk) {
        this.myHunk = hunk;
    }

    public ApplyPatchStatus apply(List<String> lines) throws ApplyPatchException {
        ArrayList<String> originalLines = new ArrayList<String>(lines);
        try {
            return this.tryApply(lines, false);
        }
        catch (ApplyPatchException ex) {
            lines.clear();
            lines.addAll(originalLines);
            return this.tryApply(lines, true);
        }
    }

    private ApplyPatchStatus tryApply(List<String> lines, boolean acceptPartial) throws ApplyPatchException {
        List hunkLines = this.myHunk.getLines();
        ApplyPatchStatus result2 = null;
        int curLine = this.findStartLine(hunkLines, lines);
        for (PatchLine line : hunkLines) {
            String patchLineText = line.getText();
            switch (line.getType()) {
                case CONTEXT: {
                    ApplyPatchHunk.checkContextMismatch(lines, curLine, patchLineText);
                    ++curLine;
                    break;
                }
                case ADD: {
                    if (curLine < lines.size() && lines.get(curLine).equals(patchLineText) && acceptPartial) {
                        result2 = ApplyPatchStatus.and(result2, ApplyPatchStatus.ALREADY_APPLIED);
                    } else {
                        lines.add(curLine, patchLineText);
                        result2 = ApplyPatchStatus.and(result2, ApplyPatchStatus.SUCCESS);
                    }
                    ++curLine;
                    break;
                }
                case REMOVE: {
                    if (curLine >= lines.size() || !patchLineText.equals(lines.get(curLine))) {
                        if (acceptPartial) {
                            result2 = ApplyPatchStatus.and(result2, ApplyPatchStatus.ALREADY_APPLIED);
                            break;
                        }
                        ApplyPatchHunk.checkContextMismatch(lines, curLine, patchLineText);
                        break;
                    }
                    lines.remove(curLine);
                    result2 = ApplyPatchStatus.and(result2, ApplyPatchStatus.SUCCESS);
                }
            }
        }
        if (result2 != null) {
            return result2;
        }
        return ApplyPatchStatus.SUCCESS;
    }

    private static void checkContextMismatch(List<String> lines, int curLine, String patchLineText) throws ApplyPatchException {
        if (curLine >= lines.size()) {
            throw new ApplyPatchException("Unexpected end of document. Expected line:\n" + patchLineText);
        }
        if (!patchLineText.equals(lines.get(curLine))) {
            throw new ApplyPatchException("Context mismatch. Expected line:\n" + patchLineText + "\nFound line:\n" + lines.get(curLine));
        }
    }

    private int findStartLine(List<PatchLine> hunkLines, List<String> lines) throws ApplyPatchException {
        int totalContextLines = this.countContextLines(hunkLines);
        int startLineBefore = this.myHunk.getStartLineBefore();
        if (this.getLinesProcessingContext(hunkLines, lines, startLineBefore) == totalContextLines) {
            return startLineBefore;
        }
        int maxContextStartLine = -1;
        int maxContextLines = 0;
        for (int i = 0; i < lines.size(); ++i) {
            int contextLines = this.getLinesProcessingContext(hunkLines, lines, i);
            if (contextLines == totalContextLines) {
                return i;
            }
            if (contextLines <= maxContextLines) continue;
            maxContextLines = contextLines;
            maxContextStartLine = i;
        }
        if (maxContextLines < 2) {
            throw new ApplyPatchException("couldn't find context");
        }
        return maxContextStartLine;
    }

    private int countContextLines(List<PatchLine> hunkLines) {
        int count = 0;
        for (PatchLine line : hunkLines) {
            if (line.getType() != PatchLine.Type.CONTEXT && line.getType() != PatchLine.Type.REMOVE) continue;
            ++count;
        }
        return count;
    }

    private int getLinesProcessingContext(List<PatchLine> hunkLines, List<String> lines, int startLine) {
        int count = 0;
        for (PatchLine line : hunkLines) {
            PatchLine.Type type = line.getType();
            if (type != PatchLine.Type.REMOVE && type != PatchLine.Type.CONTEXT) continue;
            if (startLine >= lines.size() || !line.getText().equals(lines.get(startLine))) {
                return count;
            }
            ++count;
            ++startLine;
        }
        return count;
    }
}

