/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.util.ui.MacUIUtil;
import org.jetbrains.annotations.NotNull;

public class BackspaceAction
extends TextComponentEditorAction {
    public BackspaceAction() {
        super((EditorActionHandler)new Handler());
    }

    private static void doBackSpaceAtCaret(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/BackspaceAction", "doBackSpaceAtCaret"));
        }
        if (editor.getSelectionModel().hasSelection()) {
            EditorModificationUtil.deleteSelectedText((Editor)editor);
            return;
        }
        int lineNumber = editor.getCaretModel().getLogicalPosition().line;
        int colNumber = editor.getCaretModel().getLogicalPosition().column;
        Document document2 = editor.getDocument();
        int offset = editor.getCaretModel().getOffset();
        if (colNumber > 0) {
            if (EditorModificationUtil.calcAfterLineEnd((Editor)editor) > 0) {
                int columnShift = -1;
                editor.getCaretModel().moveCaretRelatively(columnShift, 0, false, false, true);
            } else {
                EditorModificationUtil.scrollToCaret((Editor)editor);
                editor.getSelectionModel().removeSelection();
                FoldRegion region = editor.getFoldingModel().getCollapsedRegionAtOffset(offset - 1);
                if (region != null && region.shouldNeverExpand()) {
                    document2.deleteString(region.getStartOffset(), region.getEndOffset());
                    editor.getCaretModel().moveToOffset(region.getStartOffset());
                } else {
                    document2.deleteString(offset - 1, offset);
                    editor.getCaretModel().moveToOffset(offset - 1, true);
                }
            }
        } else if (lineNumber > 0) {
            int separatorLength = document2.getLineSeparatorLength(lineNumber - 1);
            int lineEnd = document2.getLineEndOffset(lineNumber - 1) + separatorLength;
            document2.deleteString(lineEnd - separatorLength, lineEnd);
            editor.getCaretModel().moveToOffset(lineEnd - separatorLength);
            EditorModificationUtil.scrollToCaret((Editor)editor);
            editor.getSelectionModel().removeSelection();
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            commandProcessor.setCurrentCommandGroupId(null);
        }
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
            super(true);
        }

        public void executeWriteAction(Editor editor, Caret caret, DataContext dataContext) {
            MacUIUtil.hideCursor();
            CommandProcessor.getInstance().setCurrentCommandGroupId(EditorActionUtil.DELETE_COMMAND_GROUP);
            if (editor instanceof EditorWindow) {
                editor = ((EditorWindow)editor).getDelegate();
            }
            BackspaceAction.doBackSpaceAtCaret(editor);
        }
    }
}

