/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.registry.Registry;

class MoveCaretLeftOrRightHandler
extends EditorActionHandler {
    private final Direction myDirection;

    MoveCaretLeftOrRightHandler(Direction direction) {
        super(true);
        this.myDirection = direction;
    }

    public void doExecute(Editor editor, Caret caret, DataContext dataContext) {
        SelectionModel selectionModel = editor.getSelectionModel();
        CaretModel caretModel = editor.getCaretModel();
        ScrollingModel scrollingModel = editor.getScrollingModel();
        if (!(!selectionModel.hasSelection() || editor instanceof EditorEx && ((EditorEx)editor).isStickySelection())) {
            if (editor.getIndentsModel().getCaretIndentGuide() != null) {
                selectionModel.removeSelection();
            } else {
                int start = selectionModel.getSelectionStart();
                int end = selectionModel.getSelectionEnd();
                int caretOffset = caretModel.getOffset();
                if (start <= caretOffset && end >= caretOffset) {
                    VisualPosition targetPosition = null;
                    if (Registry.is((String)"editor.new.rendering")) {
                        targetPosition = this.myDirection == Direction.RIGHT ? caret.getSelectionEndPosition() : caret.getSelectionStartPosition();
                    } else if (caretModel.supportsMultipleCarets() && editor.isColumnMode()) {
                        targetPosition = this.myDirection == Direction.RIGHT ? selectionModel.getSelectionEndPosition() : selectionModel.getSelectionStartPosition();
                    }
                    selectionModel.removeSelection();
                    if (targetPosition != null) {
                        caretModel.moveToVisualPosition(targetPosition);
                    } else {
                        caretModel.moveToOffset(this.myDirection == Direction.RIGHT ^ caret.isAtRtlLocation() ? end : start);
                    }
                    if (caret == editor.getCaretModel().getPrimaryCaret()) {
                        scrollingModel.scrollToCaret(ScrollType.RELATIVE);
                    }
                    return;
                }
            }
        }
        VisualPosition currentPosition = caret.getVisualPosition();
        if (caret.isAtBidiRunBoundary() && this.myDirection == Direction.RIGHT ^ currentPosition.leansRight) {
            caret.moveToVisualPosition(currentPosition.leanRight(!currentPosition.leansRight));
        } else {
            boolean scrollToCaret = (!(editor instanceof EditorImpl) || ((EditorImpl)editor).isScrollToCaret()) && caret == editor.getCaretModel().getPrimaryCaret();
            caretModel.moveCaretRelatively(this.myDirection == Direction.RIGHT ? 1 : -1, 0, false, false, scrollToCaret);
        }
    }

    static enum Direction {
        LEFT,
        RIGHT;

    }
}

