/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.WeakList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyRangeMarkerFactoryImpl
extends LazyRangeMarkerFactory {
    private final Project myProject;
    private static final Key<WeakList<LazyMarker>> LAZY_MARKERS_KEY = Key.create((String)"LAZY_MARKERS_KEY");

    public LazyRangeMarkerFactoryImpl(@NotNull Project project2, final @NotNull FileDocumentManager fileDocumentManager) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl", "<init>"));
        }
        if (fileDocumentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDocumentManager", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl", "<init>"));
        }
        this.myProject = project2;
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void beforeDocumentChange(DocumentEvent e) {
                this.transformRangeMarkers(e);
            }

            public void documentChanged(DocumentEvent e) {
                this.transformRangeMarkers(e);
            }

            private void transformRangeMarkers(@NotNull DocumentEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$1", "transformRangeMarkers"));
                }
                Document document2 = e.getDocument();
                VirtualFile file2 = fileDocumentManager.getFile(document2);
                if (file2 == null || LazyRangeMarkerFactoryImpl.this.myProject.isDisposed()) {
                    return;
                }
                WeakList<LazyMarker> lazyMarkers = LazyRangeMarkerFactoryImpl.getMarkers(file2);
                if (lazyMarkers == null) {
                    return;
                }
                List markers = lazyMarkers.toStrongList();
                for (LazyMarker marker : markers) {
                    if (!file2.equals(marker.getFile())) continue;
                    marker.getOrCreateDelegate();
                }
            }
        }, (Disposable)project2);
    }

    static WeakList<LazyMarker> getMarkers(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl", "getMarkers"));
        }
        return (WeakList)file2.getUserData(LAZY_MARKERS_KEY);
    }

    private static void addToLazyMarkersList(@NotNull LazyMarker marker, @NotNull VirtualFile file2) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl", "addToLazyMarkersList"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl", "addToLazyMarkersList"));
        }
        WeakList markers = LazyRangeMarkerFactoryImpl.getMarkers(file2);
        if (markers == null) {
            markers = (WeakList)file2.putUserDataIfAbsent(LAZY_MARKERS_KEY, (Object)new WeakList());
        }
        markers.add((Object)marker);
    }

    private static void removeFromLazyMarkersList(@NotNull LazyMarker marker, @NotNull VirtualFile file2) {
        if (marker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "marker", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl", "removeFromLazyMarkersList"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl", "removeFromLazyMarkersList"));
        }
        WeakList<LazyMarker> markers = LazyRangeMarkerFactoryImpl.getMarkers(file2);
        if (markers != null) {
            markers.remove((Object)marker);
        }
    }

    @NotNull
    public RangeMarker createRangeMarker(final @NotNull VirtualFile file2, final int offset) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl", "createRangeMarker"));
        }
        RangeMarker rangeMarker = (RangeMarker)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RangeMarker>(){

            public RangeMarker compute() {
                OffsetLazyMarker marker = new OffsetLazyMarker(file2, offset);
                LazyRangeMarkerFactoryImpl.addToLazyMarkersList(marker, file2);
                return marker;
            }
        });
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl", "createRangeMarker"));
        }
        return rangeMarker;
    }

    @NotNull
    public RangeMarker createRangeMarker(final @NotNull VirtualFile file2, final int line, final int column, final boolean persistent) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl", "createRangeMarker"));
        }
        RangeMarker rangeMarker = (RangeMarker)ApplicationManager.getApplication().runReadAction((Computable)new Computable<RangeMarker>(){

            public RangeMarker compute() {
                Document document2 = FileDocumentManager.getInstance().getCachedDocument(file2);
                if (document2 != null) {
                    int myTabSize = CodeStyleFacade.getInstance((Project)LazyRangeMarkerFactoryImpl.this.myProject).getTabSize(file2.getFileType());
                    int offset = LazyRangeMarkerFactoryImpl.calculateOffset(document2, line, column, myTabSize);
                    return document2.createRangeMarker(offset, offset, persistent);
                }
                LineColumnLazyMarker marker = new LineColumnLazyMarker(LazyRangeMarkerFactoryImpl.this.myProject, file2, line, column);
                LazyRangeMarkerFactoryImpl.addToLazyMarkersList(marker, file2);
                return marker;
            }
        });
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl", "createRangeMarker"));
        }
        return rangeMarker;
    }

    private static int calculateOffset(@NotNull Document document2, int line, int column, int tabSize) {
        int offset;
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl", "calculateOffset"));
        }
        if (0 <= line && line < document2.getLineCount()) {
            int lineStart = document2.getLineStartOffset(line);
            int lineEnd = document2.getLineEndOffset(line);
            CharSequence docText = document2.getCharsSequence();
            offset = lineStart;
            for (int col = 0; offset < lineEnd && col < column; col += docText.charAt(offset) == '\t' ? tabSize : 1, ++offset) {
            }
        } else {
            offset = document2.getTextLength();
        }
        return offset;
    }

    private static class LineColumnLazyMarker
    extends LazyMarker {
        private final int myLine;
        private final int myColumn;
        private final int myTabSize;

        private LineColumnLazyMarker(@NotNull Project project2, @NotNull VirtualFile file2, int line, int column) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$LineColumnLazyMarker", "<init>"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$LineColumnLazyMarker", "<init>"));
            }
            super(file2, -1);
            this.myLine = line;
            this.myColumn = column;
            this.myTabSize = CodeStyleFacade.getInstance((Project)project2).getTabSize(file2.getFileType());
        }

        @Override
        @Nullable
        public RangeMarker createDelegate(@NotNull VirtualFile file2, @NotNull Document document2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$LineColumnLazyMarker", "createDelegate"));
            }
            if (document2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$LineColumnLazyMarker", "createDelegate"));
            }
            if (document2.getTextLength() == 0 && (this.myLine != 0 || this.myColumn != 0)) {
                return null;
            }
            int offset = LazyRangeMarkerFactoryImpl.calculateOffset(document2, this.myLine, this.myColumn, this.myTabSize);
            return document2.createRangeMarker(offset, offset);
        }

        @Override
        public boolean isValid() {
            RangeMarker delegate = this.myDelegate;
            if (delegate == null) {
                Document document2 = FileDocumentManager.getInstance().getDocument(this.myFile);
                return document2 != null && (document2.getTextLength() != 0 || this.myLine == 0 && this.myColumn == 0);
            }
            return super.isValid();
        }

        @Override
        public int getStartOffset() {
            this.getOrCreateDelegate();
            return super.getStartOffset();
        }

        @Override
        public int getEndOffset() {
            this.getOrCreateDelegate();
            return super.getEndOffset();
        }
    }

    private static class OffsetLazyMarker
    extends LazyMarker {
        private OffsetLazyMarker(@NotNull VirtualFile file2, int offset) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$OffsetLazyMarker", "<init>"));
            }
            super(file2, offset);
        }

        @Override
        public boolean isValid() {
            RangeMarker delegate = this.myDelegate;
            if (delegate == null) {
                Document document2 = FileDocumentManager.getInstance().getDocument(this.myFile);
                return document2 != null;
            }
            return super.isValid();
        }

        @Override
        @NotNull
        public RangeMarker createDelegate(@NotNull VirtualFile file2, @NotNull Document document2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$OffsetLazyMarker", "createDelegate"));
            }
            if (document2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$OffsetLazyMarker", "createDelegate"));
            }
            int offset = Math.min(this.myInitialOffset, document2.getTextLength());
            RangeMarker rangeMarker = document2.createRangeMarker(offset, offset);
            if (rangeMarker == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$OffsetLazyMarker", "createDelegate"));
            }
            return rangeMarker;
        }
    }

    static abstract class LazyMarker
    extends UserDataHolderBase
    implements RangeMarker {
        protected RangeMarker myDelegate;
        protected final VirtualFile myFile;
        protected final int myInitialOffset;

        private LazyMarker(@NotNull VirtualFile file2, int offset) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$LazyMarker", "<init>"));
            }
            this.myFile = file2;
            this.myInitialOffset = offset;
        }

        boolean isDelegated() {
            return this.myDelegate != null;
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$LazyMarker", "getFile"));
            }
            return virtualFile;
        }

        @Nullable
        final RangeMarker getOrCreateDelegate() {
            if (this.myDelegate == null) {
                Document document2 = FileDocumentManager.getInstance().getDocument(this.myFile);
                if (document2 == null) {
                    return null;
                }
                this.myDelegate = this.createDelegate(this.myFile, document2);
                LazyRangeMarkerFactoryImpl.removeFromLazyMarkersList(this, this.myFile);
            }
            return this.isDisposed() ? null : this.myDelegate;
        }

        @Nullable
        protected abstract RangeMarker createDelegate(@NotNull VirtualFile var1, @NotNull Document var2);

        @NotNull
        public Document getDocument() {
            RangeMarker delegate = this.getOrCreateDelegate();
            if (delegate == null) {
                Document document2 = FileDocumentManager.getInstance().getDocument(this.myFile);
                if (document2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$LazyMarker", "getDocument"));
                }
                return document2;
            }
            Document document3 = delegate.getDocument();
            if (document3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/impl/LazyRangeMarkerFactoryImpl$LazyMarker", "getDocument"));
            }
            return document3;
        }

        public int getStartOffset() {
            return this.myDelegate == null || this.isDisposed() ? this.myInitialOffset : this.myDelegate.getStartOffset();
        }

        public boolean isDisposed() {
            return this.myDelegate == this;
        }

        public int getEndOffset() {
            return this.myDelegate == null || this.isDisposed() ? this.myInitialOffset : this.myDelegate.getEndOffset();
        }

        public boolean isValid() {
            RangeMarker delegate = this.getOrCreateDelegate();
            return delegate != null && !this.isDisposed() && delegate.isValid();
        }

        public void setGreedyToLeft(boolean greedy) {
            this.getOrCreateDelegate().setGreedyToLeft(greedy);
        }

        public void setGreedyToRight(boolean greedy) {
            this.getOrCreateDelegate().setGreedyToRight(greedy);
        }

        public boolean isGreedyToRight() {
            return this.getOrCreateDelegate().isGreedyToRight();
        }

        public boolean isGreedyToLeft() {
            return this.getOrCreateDelegate().isGreedyToLeft();
        }

        public void dispose() {
            assert (!this.isDisposed());
            RangeMarker delegate = this.myDelegate;
            if (delegate == null) {
                LazyRangeMarkerFactoryImpl.removeFromLazyMarkersList(this, this.myFile);
                this.myDelegate = this;
            } else {
                delegate.dispose();
            }
        }
    }
}

