/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.view.TextFragment;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class SimpleTextFragment
extends TextFragment {
    @NotNull
    private final char[] myText;
    @NotNull
    private final Font myFont;

    SimpleTextFragment(@NotNull char[] lineChars, int start, int end, @NotNull FontInfo fontInfo) {
        if (lineChars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineChars", "com/intellij/openapi/editor/impl/view/SimpleTextFragment", "<init>"));
        }
        if (fontInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fontInfo", "com/intellij/openapi/editor/impl/view/SimpleTextFragment", "<init>"));
        }
        super(end - start);
        this.myText = Arrays.copyOfRange(lineChars, start, end);
        this.myFont = fontInfo.getFont();
        float x = 0.0f;
        for (int i = 0; i < this.myText.length; ++i) {
            this.myCharPositions[i] = x += (float)fontInfo.charWidth(this.myText[i]);
        }
    }

    @Override
    boolean isRtl() {
        return false;
    }

    @Override
    public void draw(Graphics2D g, float x, float y, int startColumn, int endColumn) {
        g.setFont(this.myFont);
        g.drawChars(this.myText, startColumn, endColumn - startColumn, (int)x, (int)y);
    }
}

