/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemTaskSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemRunConfigurationEditor
extends SettingsEditor<ExternalSystemRunConfiguration> {
    @NotNull
    private final ExternalSystemTaskSettingsControl myControl;

    public ExternalSystemRunConfigurationEditor(@NotNull Project project2, @NotNull ProjectSystemId externalSystemId) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfigurationEditor", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfigurationEditor", "<init>"));
        }
        this.myControl = new ExternalSystemTaskSettingsControl(project2, externalSystemId);
    }

    protected void resetEditorFrom(ExternalSystemRunConfiguration s) {
        this.myControl.setOriginalSettings(s.getSettings());
        this.myControl.reset();
    }

    protected void applyEditorTo(ExternalSystemRunConfiguration s) throws ConfigurationException {
        this.myControl.apply(s.getSettings());
    }

    @NotNull
    protected JComponent createEditor() {
        PaintAwarePanel result2 = new PaintAwarePanel(new GridBagLayout());
        this.myControl.fillUi(result2, 0);
        result2.add((Component)new Box.Filler(new Dimension(0, 0), new Dimension(0, 200), new Dimension(0, 0)), ExternalSystemUiUtil.getFillLineConstraints(0));
        ExternalSystemUiUtil.fillBottom(result2);
        PaintAwarePanel paintAwarePanel = result2;
        if (paintAwarePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/execution/ExternalSystemRunConfigurationEditor", "createEditor"));
        }
        return paintAwarePanel;
    }

    protected void disposeEditor() {
        this.myControl.disposeUIResources();
    }
}

