/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.TemplateLanguageFileType;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class FileTypePatternDialog {
    private JTextField myPatternField;
    private JComboBox myLanguageCombo;
    private JLabel myTemplateDataLanguageButton;
    private JPanel myMainPanel;

    public FileTypePatternDialog(@Nullable String initialPatterns, FileType fileType, Language templateDataLanguage) {
        this.$$$setupUI$$$();
        this.myPatternField.setText(initialPatterns);
        if (fileType instanceof TemplateLanguageFileType) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.myLanguageCombo.getModel();
            model.addElement(null);
            List<Language> languages = TemplateDataLanguageMappings.getTemplateableLanguages();
            Collections.sort(languages, (o1, o2) -> o1.getID().compareTo(o2.getID()));
            for (Language language : languages) {
                model.addElement(language);
            }
            this.myLanguageCombo.setRenderer(new ListCellRendererWrapper(){

                public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                    LanguageFileType type;
                    this.setText(value == null ? "" : ((Language)value).getDisplayName());
                    if (value != null && (type = ((Language)value).getAssociatedFileType()) != null) {
                        this.setIcon(type.getIcon());
                    }
                }
            });
            this.myLanguageCombo.setSelectedItem(templateDataLanguage);
        } else {
            this.myLanguageCombo.setVisible(false);
            this.myTemplateDataLanguageButton.setVisible(false);
        }
    }

    public JTextField getPatternField() {
        return this.myPatternField;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public Language getTemplateDataLanguage() {
        return (Language)this.myLanguageCombo.getSelectedItem();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JLabel jLabel;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPatternField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/FileTypesBundle").getString("filetype.edit.add.pattern.prompt"));
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTemplateDataLanguageButton = jLabel = new JLabel();
        jLabel.setText("Template data language:");
        jLabel.setDisplayedMnemonic('T');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLanguageCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        jLabel2.setLabelFor(jTextField);
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

