/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.impl.BundledKeymapProvider;
import com.intellij.openapi.keymap.impl.DefaultKeymapImpl;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.MacOSDefaultKeymap;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SystemInfo;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DefaultKeymap {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.keymap.impl.DefaultKeymap");
    @NonNls
    private static final String KEY_MAP = "keymap";
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    private final List<Keymap> myKeymaps = new ArrayList<Keymap>();

    public static DefaultKeymap getInstance() {
        return (DefaultKeymap)ServiceManager.getService(DefaultKeymap.class);
    }

    public DefaultKeymap() {
        for (BundledKeymapProvider provider : this.getProviders()) {
            List<String> fileNames = provider.getKeymapFileNames();
            for (String fileName : fileNames) {
                try {
                    this.loadKeymapsFromElement(JDOMUtil.loadResourceDocument((URL)new URL("file:///idea/" + fileName)).getRootElement());
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    @NotNull
    protected BundledKeymapProvider[] getProviders() {
        BundledKeymapProvider[] bundledKeymapProviderArray = (BundledKeymapProvider[])Extensions.getExtensions(BundledKeymapProvider.EP_NAME);
        if (bundledKeymapProviderArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/DefaultKeymap", "getProviders"));
        }
        return bundledKeymapProviderArray;
    }

    private void loadKeymapsFromElement(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/keymap/impl/DefaultKeymap", "loadKeymapsFromElement"));
        }
        for (Element child : element.getChildren(KEY_MAP)) {
            String keymapName = child.getAttributeValue(NAME_ATTRIBUTE);
            DefaultKeymapImpl keymap = keymapName.startsWith("Mac OS X") ? new MacOSDefaultKeymap() : new DefaultKeymapImpl();
            keymap.readExternal(child, this.myKeymaps.toArray(new Keymap[this.myKeymaps.size()]));
            keymap.setName(keymapName);
            this.myKeymaps.add(keymap);
        }
    }

    @NotNull
    public Keymap[] getKeymaps() {
        Keymap[] keymapArray = this.myKeymaps.toArray(new Keymap[this.myKeymaps.size()]);
        if (keymapArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/DefaultKeymap", "getKeymaps"));
        }
        return keymapArray;
    }

    public String getDefaultKeymapName() {
        if (SystemInfo.isMac) {
            return "Mac OS X";
        }
        if (SystemInfo.isXWindow) {
            if (SystemInfo.isKDE) {
                return "Default for KDE";
            }
            return "Default for XWin";
        }
        return "$default";
    }

    public String getKeymapPresentableName(@NotNull KeymapImpl keymap) {
        if (keymap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", KEY_MAP, "com/intellij/openapi/keymap/impl/DefaultKeymap", "getKeymapPresentableName"));
        }
        String name = keymap.getName();
        if ("NetBeans 6.5".equals(name)) {
            return "NetBeans";
        }
        return "$default".equals(name) ? "Default" : name;
    }
}

