/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.BundleBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableEP;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.ConfigurableProvider;
import com.intellij.openapi.options.OptionalConfigurable;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableFilter;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.options.ex.SortedConfigurableGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableExtensionPointUtil {
    private static final Logger LOG = Logger.getInstance(ConfigurableExtensionPointUtil.class);

    private ConfigurableExtensionPointUtil() {
    }

    public static List<Configurable> buildConfigurablesList(ConfigurableEP<Configurable>[] extensions, @Nullable ConfigurableFilter filter) {
        ArrayList<Configurable> result2 = new ArrayList<Configurable>();
        HashMap idToConfigurable = ContainerUtil.newHashMap();
        ArrayList idsInEpOrder = ContainerUtil.newArrayList();
        for (ConfigurableEP<Configurable> ep : extensions) {
            Configurable configurable = ConfigurableWrapper.wrapConfigurable(ep);
            if (ConfigurableExtensionPointUtil.isSuppressed(configurable, filter)) continue;
            if (configurable instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                idToConfigurable.put(wrapper.getId(), wrapper);
                idsInEpOrder.add(wrapper.getId());
                continue;
            }
            ContainerUtil.addIfNotNull((Object)configurable, result2);
        }
        HashSet visited = ContainerUtil.newHashSet();
        Map<String, List<String>> idTree = ConfigurableExtensionPointUtil.buildIdTree(idToConfigurable, idsInEpOrder);
        for (String id : idsInEpOrder) {
            ConfigurableExtensionPointUtil.addChildrenRec(id, idToConfigurable, visited, idTree);
        }
        for (String id : idsInEpOrder) {
            ConfigurableWrapper wrapper = (ConfigurableWrapper)idToConfigurable.get(id);
            String parentId = wrapper.getParentId();
            if (parentId != null && idToConfigurable.containsKey(parentId)) continue;
            result2.add((Configurable)wrapper);
        }
        return result2;
    }

    @NotNull
    private static ConfigurableWrapper addChildrenRec(@NotNull String id, @NotNull Map<String, ConfigurableWrapper> idToConfigurable, @NotNull Set<String> visited, @NotNull Map<String, List<String>> idTree) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        if (idToConfigurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToConfigurable", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        if (visited == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visited", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        if (idTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idTree", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        ConfigurableWrapper wrapper = idToConfigurable.get(id);
        if (visited.contains(id)) {
            ConfigurableWrapper configurableWrapper = wrapper;
            if (configurableWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
            }
            return configurableWrapper;
        }
        visited.add(id);
        List<String> childIds = idTree.get(id);
        if (childIds != null) {
            for (String childId : childIds) {
                ConfigurableWrapper childWrapper = ConfigurableExtensionPointUtil.addChildrenRec(childId, idToConfigurable, visited, idTree);
                wrapper = wrapper.addChild((Configurable)childWrapper);
            }
            idToConfigurable.put(id, wrapper);
        }
        ConfigurableWrapper configurableWrapper = wrapper;
        if (configurableWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "addChildrenRec"));
        }
        return configurableWrapper;
    }

    @NotNull
    private static Map<String, List<String>> buildIdTree(@NotNull Map<String, ConfigurableWrapper> idToConfigurable, @NotNull List<String> idsInEpOrder) {
        if (idToConfigurable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idToConfigurable", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "buildIdTree"));
        }
        if (idsInEpOrder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "idsInEpOrder", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "buildIdTree"));
        }
        HashMap tree = ContainerUtil.newHashMap();
        for (String id : idsInEpOrder) {
            ConfigurableWrapper wrapper = idToConfigurable.get(id);
            String parentId = wrapper.getParentId();
            if (parentId == null) continue;
            ConfigurableWrapper parent = idToConfigurable.get(parentId);
            if (parent == null) {
                LOG.warn("Can't find parent for " + parentId + " (" + wrapper + ")");
                continue;
            }
            List children2 = (List)tree.get(parentId);
            if (children2 == null) {
                children2 = ContainerUtil.newArrayListWithCapacity((int)5);
                tree.put(parentId, children2);
            }
            children2.add(id);
        }
        HashMap hashMap = tree;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "buildIdTree"));
        }
        return hashMap;
    }

    public static ConfigurableGroup getConfigurableGroup(@Nullable Project project2, boolean withIdeSettings) {
        return ConfigurableExtensionPointUtil.getConfigurableGroup(ConfigurableExtensionPointUtil.getConfigurables(project2, withIdeSettings), project2);
    }

    public static ConfigurableGroup getConfigurableGroup(@NotNull List<Configurable> configurables, @Nullable Project project2) {
        if (configurables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurables", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "getConfigurableGroup"));
        }
        Map<String, List<Configurable>> map = ConfigurableExtensionPointUtil.groupConfigurables(configurables);
        HashMap tree = ContainerUtil.newHashMap();
        for (Map.Entry<String, List<Configurable>> entry : map.entrySet()) {
            ConfigurableExtensionPointUtil.addGroup(tree, project2, entry.getKey(), entry.getValue(), null);
        }
        SortedConfigurableGroup root = ConfigurableExtensionPointUtil.getGroup(tree, "root");
        if (!tree.isEmpty()) {
            for (String groupId : tree.keySet()) {
                LOG.warn("ignore group: " + groupId);
            }
        }
        if (root != null && root.myList != null && Registry.is((String)"ide.settings.replace.group.with.single.configurable")) {
            ConfigurableExtensionPointUtil.replaceGroupWithSingleConfigurable(root.myList);
        }
        return root;
    }

    private static void replaceGroupWithSingleConfigurable(List<Configurable> list) {
        for (int i = 0; i < list.size(); ++i) {
            SortedConfigurableGroup group;
            Configurable configurable = list.get(i);
            if (!(configurable instanceof SortedConfigurableGroup) || (configurable = ConfigurableExtensionPointUtil.getConfigurableToReplace(group.myList, (group = (SortedConfigurableGroup)configurable).getWeight())) == null) continue;
            list.set(i, configurable);
        }
    }

    private static Configurable getConfigurableToReplace(List<Configurable> list, int weight) {
        if (list != null) {
            ConfigurableExtensionPointUtil.replaceGroupWithSingleConfigurable(list);
            if (1 == list.size()) {
                Configurable configurable = list.get(0);
                if (configurable instanceof SortedConfigurableGroup) {
                    SortedConfigurableGroup group = (SortedConfigurableGroup)configurable;
                    group.myWeight = weight;
                    return group;
                }
                if (configurable instanceof ConfigurableWrapper) {
                    ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                    wrapper.myWeight = weight;
                    return wrapper;
                }
            }
        }
        return null;
    }

    private static SortedConfigurableGroup getGroup(Map<String, Node<SortedConfigurableGroup>> tree, String groupId) {
        Node<SortedConfigurableGroup> node = tree.remove(groupId);
        if (node.myChildren != null) {
            Iterator<Object> iterator = node.myChildren.iterator();
            while (iterator.hasNext()) {
                String childId = (String)iterator.next();
                ((SortedConfigurableGroup)node.myValue).myList.add((Configurable)ConfigurableExtensionPointUtil.getGroup(tree, childId));
                iterator.remove();
            }
        }
        return (SortedConfigurableGroup)node.myValue;
    }

    private static void addGroup(Map<String, Node<SortedConfigurableGroup>> tree, Project project2, String groupId, List<Configurable> configurables, ResourceBundle alternative) {
        String id = "configurable.group." + groupId;
        ResourceBundle bundle = ConfigurableExtensionPointUtil.getBundle(id + ".settings.display.name", configurables, alternative);
        if (bundle == null) {
            bundle = OptionsBundle.getBundle();
            if ("root".equals(groupId)) {
                try {
                    String value = bundle.getString("configurable.group.root.settings.display.name");
                    LOG.error("OptionsBundle does not contain root group", new String[]{value});
                }
                catch (Exception exception) {
                    LOG.error("OptionsBundle does not contain root group", (Throwable)exception);
                }
            } else {
                LOG.warn("use other group instead of unexpected one: " + groupId);
                groupId = "other";
                id = "configurable.group." + groupId;
            }
        }
        Node node = Node.get(tree, groupId);
        if (node.myValue == null) {
            int weight = ConfigurableExtensionPointUtil.getInt(bundle, id + ".settings.weight");
            String help = ConfigurableExtensionPointUtil.getString(bundle, id + ".settings.help.topic");
            String name = ConfigurableExtensionPointUtil.getString(bundle, id + ".settings.display.name");
            if (name != null && project2 != null) {
                if (!project2.isDefault() && !name.contains("{")) {
                    String named = ConfigurableExtensionPointUtil.getString(bundle, id + ".named.settings.display.name");
                    String string = name = named != null ? named : name;
                }
                if (name.contains("{")) {
                    name = StringUtil.first((String)MessageFormat.format(name, project2.getName()), (int)30, (boolean)true);
                }
            }
            node.myValue = new SortedConfigurableGroup(id, name, help, weight);
        }
        if (configurables != null) {
            ((SortedConfigurableGroup)node.myValue).myList.addAll(configurables);
        }
        if (node.myParent == null && !groupId.equals("root")) {
            String parentId = ConfigurableExtensionPointUtil.getString(bundle, id + ".settings.parent");
            parentId = (String)Node.cyclic(tree, parentId, "root", groupId, node);
            node.myParent = Node.add(tree, parentId, groupId);
            ConfigurableExtensionPointUtil.addGroup(tree, project2, parentId, null, bundle);
        }
    }

    public static Map<String, List<Configurable>> groupConfigurables(@NotNull List<Configurable> configurables) {
        if (configurables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurables", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "groupConfigurables"));
        }
        HashMap tree = ContainerUtil.newHashMap();
        for (Configurable configurable : configurables) {
            if (configurable instanceof ConfigurableWrapper) {
                ConfigurableWrapper wrapper = (ConfigurableWrapper)configurable;
                String id = wrapper.getId();
                Node node = Node.get(tree, id);
                if (node.myValue != null) {
                    LOG.warn("ignore configurable with duplicated id: " + id);
                    continue;
                }
                String parentId = wrapper.getParentId();
                String groupId = wrapper.getExtensionPoint().groupId;
                if (groupId != null) {
                    if (parentId != null) {
                        LOG.warn("ignore deprecated groupId: " + groupId + " for id: " + id);
                    } else {
                        parentId = groupId;
                    }
                }
                parentId = (String)Node.cyclic(tree, parentId, "other", id, node);
                node.myParent = Node.add(tree, parentId, node);
                node.myValue = wrapper;
                continue;
            }
            Node.add(tree, "other", configurable);
        }
        HashMap map = ContainerUtil.newHashMap();
        for (String id : tree.keySet().toArray(new String[tree.size()])) {
            List<Configurable> list;
            Node node = (Node)tree.get(id);
            if (node == null || (list = ConfigurableExtensionPointUtil.getConfigurables(tree, node)) == null) continue;
            map.put(id, list);
            tree.remove(id);
        }
        return map;
    }

    private static List<Configurable> getConfigurables(Map<String, Node<ConfigurableWrapper>> tree, Node<ConfigurableWrapper> node) {
        if (node.myChildren == null) {
            if (node.myValue == null) {
                return ContainerUtil.newArrayList();
            }
            return null;
        }
        ArrayList list = ContainerUtil.newArrayListWithCapacity((int)node.myChildren.size());
        Iterator<Object> iterator = node.myChildren.iterator();
        while (iterator.hasNext()) {
            Object child = iterator.next();
            if (child instanceof Configurable) {
                list.add((Configurable)child);
            } else {
                Node value = (Node)child;
                if (ConfigurableExtensionPointUtil.getConfigurables(tree, value) != null) {
                    throw new IllegalStateException("unexpected algorithm state");
                }
                list.add(value.myValue);
                tree.remove(((ConfigurableWrapper)value.myValue).getId());
            }
            iterator.remove();
        }
        if (node.myValue == null) {
            return list;
        }
        for (Configurable configurable : list) {
            node.myValue = ((ConfigurableWrapper)node.myValue).addChild(configurable);
        }
        return null;
    }

    private static List<Configurable> getConfigurables(@Nullable Project project2, boolean withIdeSettings) {
        Application application;
        ArrayList list = ContainerUtil.newArrayList();
        if (withIdeSettings && (application = ApplicationManager.getApplication()) != null) {
            ConfigurableEP[] configurableEPArray = (ConfigurableEP[])application.getExtensions(Configurable.APPLICATION_CONFIGURABLE);
            int n = configurableEPArray.length;
            for (int i = 0; i < n; ++i) {
                ConfigurableEP extension = configurableEPArray[i];
                ConfigurableExtensionPointUtil.addValid(list, (Configurable)ConfigurableWrapper.wrapConfigurable(extension), null);
            }
        }
        if (project2 != null && !project2.isDisposed()) {
            for (ConfigurableEP extension : (ConfigurableEP[])project2.getExtensions(Configurable.PROJECT_CONFIGURABLE)) {
                ConfigurableExtensionPointUtil.addValid(list, (Configurable)ConfigurableWrapper.wrapConfigurable(extension), project2);
            }
        }
        return list;
    }

    private static void addValid(List<Configurable> list, Configurable configurable, Project project2) {
        if (ConfigurableExtensionPointUtil.isValid(configurable, project2)) {
            list.add(configurable);
        }
    }

    private static boolean isValid(Configurable configurable, Project project2) {
        if (configurable == null) {
            return false;
        }
        if (ConfigurableWrapper.cast(Configurable.Assistant.class, (UnnamedConfigurable)configurable) != null) {
            return false;
        }
        OptionalConfigurable optional = ConfigurableWrapper.cast(OptionalConfigurable.class, (UnnamedConfigurable)configurable);
        if (optional != null && !optional.needDisplay()) {
            return false;
        }
        return project2 == null || !project2.isDefault() || !ConfigurableWrapper.isNonDefaultProject(configurable);
    }

    @Nullable
    public static ResourceBundle getBundle(@NotNull String resource, @Nullable Iterable<Configurable> configurables, @Nullable ResourceBundle alternative) {
        if (resource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resource", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "getBundle"));
        }
        ResourceBundle bundle = OptionsBundle.getBundle();
        if (ConfigurableExtensionPointUtil.getString(bundle, resource) != null) {
            return bundle;
        }
        if (configurables != null) {
            for (Configurable configurable : configurables) {
                ConfigurableWrapper wrapper;
                if (!(configurable instanceof ConfigurableWrapper) || ConfigurableExtensionPointUtil.getString(bundle = (wrapper = (ConfigurableWrapper)configurable).getExtensionPoint().findBundle(), resource) == null) continue;
                return bundle;
            }
        }
        if (ConfigurableExtensionPointUtil.getString(alternative, resource) != null) {
            return alternative;
        }
        return null;
    }

    private static String getString(ResourceBundle bundle, String resource) {
        if (bundle == null) {
            return null;
        }
        try {
            return BundleBase.replaceMnemonicAmpersand((String)bundle.getString(resource));
        }
        catch (MissingResourceException ignored) {
            return null;
        }
    }

    private static int getInt(ResourceBundle bundle, String resource) {
        try {
            String value = ConfigurableExtensionPointUtil.getString(bundle, resource);
            return value == null ? 0 : Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    private static boolean isSuppressed(Configurable each, ConfigurableFilter filter) {
        return !ConfigurableExtensionPointUtil.isValid(each, null) || filter != null && !filter.isIncluded(each);
    }

    @NotNull
    public static <T extends Configurable> T findProjectConfigurable(@NotNull Project project2, @NotNull Class<T> configurableClass) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findProjectConfigurable"));
        }
        if (configurableClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurableClass", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findProjectConfigurable"));
        }
        T t = ConfigurableExtensionPointUtil.findConfigurable((ConfigurableEP[])project2.getExtensions(Configurable.PROJECT_CONFIGURABLE), configurableClass);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findProjectConfigurable"));
        }
        return t;
    }

    @NotNull
    public static <T extends Configurable> T findApplicationConfigurable(@NotNull Class<T> configurableClass) {
        if (configurableClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configurableClass", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findApplicationConfigurable"));
        }
        T t = ConfigurableExtensionPointUtil.findConfigurable((ConfigurableEP[])Configurable.APPLICATION_CONFIGURABLE.getExtensions(), configurableClass);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findApplicationConfigurable"));
        }
        return t;
    }

    @NotNull
    private static <T extends Configurable> T findConfigurable(ConfigurableEP<Configurable>[] extensions, Class<T> configurableClass) {
        for (ConfigurableEP<Configurable> extension : extensions) {
            Configurable configurable;
            if (!extension.canCreateConfigurable() || !configurableClass.isInstance(configurable = (Configurable)extension.createConfigurable())) continue;
            Configurable configurable2 = (Configurable)configurableClass.cast(configurable);
            if (configurable2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "findConfigurable"));
            }
            return (T)configurable2;
        }
        throw new IllegalArgumentException("Cannot find configurable of " + configurableClass);
    }

    @Nullable
    public static Configurable createProjectConfigurableForProvider(@NotNull Project project2, Class<? extends ConfigurableProvider> providerClass) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/options/ex/ConfigurableExtensionPointUtil", "createProjectConfigurableForProvider"));
        }
        return ConfigurableExtensionPointUtil.createConfigurableForProvider((ConfigurableEP[])project2.getExtensions(Configurable.PROJECT_CONFIGURABLE), providerClass);
    }

    @Nullable
    public static Configurable createApplicationConfigurableForProvider(Class<? extends ConfigurableProvider> providerClass) {
        return ConfigurableExtensionPointUtil.createConfigurableForProvider((ConfigurableEP[])Configurable.APPLICATION_CONFIGURABLE.getExtensions(), providerClass);
    }

    @Nullable
    private static Configurable createConfigurableForProvider(ConfigurableEP<Configurable>[] extensions, Class<? extends ConfigurableProvider> providerClass) {
        for (ConfigurableEP<Configurable> extension : extensions) {
            Class aClass;
            if (extension.providerClass == null || (aClass = extension.findClassNoExceptions(extension.providerClass)) == null || !providerClass.isAssignableFrom(aClass)) continue;
            return (Configurable)extension.createConfigurable();
        }
        return null;
    }

    private static final class Node<V> {
        List<Object> myChildren;
        Node<V> myParent;
        V myValue;

        private Node() {
        }

        private static <I, V> Node<V> get(Map<I, Node<V>> tree, I id) {
            Node<V> node = tree.get(id);
            if (node == null) {
                node = new Node<V>();
                tree.put(id, node);
            }
            return node;
        }

        private static <I, V> Node<V> add(Map<I, Node<V>> tree, I id, Object child) {
            Node<V> node = Node.get(tree, id);
            if (node.myChildren == null) {
                node.myChildren = ContainerUtil.newArrayList();
            }
            node.myChildren.add(child);
            return node;
        }

        private static <I, V> boolean cyclic(Map<I, Node<V>> tree, I id, Node<V> parent) {
            Node<V> node = tree.get(id);
            while (node != null) {
                if (node == parent) {
                    return true;
                }
                node = node.myParent;
            }
            return false;
        }

        private static <I, V> I cyclic(Map<I, Node<V>> tree, I id, I idDefault, I idNode, Node<V> parent) {
            if (id == null) {
                id = idDefault;
            }
            if (Node.cyclic(tree, id, parent)) {
                LOG.warn("ignore cyclic dependency: " + id + " cannot contain " + idNode);
                id = idDefault;
            }
            return id;
        }
    }
}

