/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ex;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.rt.compiler.JavacRunner;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.ReflectionUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSdkUtil {
    @NonNls
    public static final String IDEA_PREPEND_RTJAR = "idea.prepend.rtjar";

    public static void addRtJar(PathsList pathsList) {
        String ideaRtJarPath = JavaSdkUtil.getIdeaRtJarPath();
        if (Boolean.getBoolean(IDEA_PREPEND_RTJAR)) {
            pathsList.addFirst(ideaRtJarPath);
        } else {
            pathsList.addTail(ideaRtJarPath);
        }
    }

    public static String getJunit4JarPath() {
        return PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"org.junit.Test"));
    }

    public static String getJunit3JarPath() {
        return PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"junit.runner.TestSuiteLoader"));
    }

    public static String getIdeaRtJarPath() {
        return PathUtil.getJarPathForClass(JavacRunner.class);
    }

    @NotNull
    public static List<String> getJUnit4JarPaths() {
        List<String> list = Arrays.asList(JavaSdkUtil.getJunit4JarPath(), PathUtil.getJarPathForClass((Class)ReflectionUtil.forName((String)"org.hamcrest.Matcher")));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/ex/JavaSdkUtil", "getJUnit4JarPaths"));
        }
        return list;
    }

    public static boolean isLanguageLevelAcceptable(@NotNull Project project2, @NotNull Module module2, @NotNull LanguageLevel level) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/projectRoots/ex/JavaSdkUtil", "isLanguageLevelAcceptable"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/projectRoots/ex/JavaSdkUtil", "isLanguageLevelAcceptable"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/projectRoots/ex/JavaSdkUtil", "isLanguageLevelAcceptable"));
        }
        return JavaSdkUtil.isJdkSupportsLevel(JavaSdkUtil.getRelevantJdk(project2, module2), level);
    }

    private static boolean isJdkSupportsLevel(@Nullable Sdk jdk2, @NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/projectRoots/ex/JavaSdkUtil", "isJdkSupportsLevel"));
        }
        if (jdk2 == null) {
            return true;
        }
        String versionString = jdk2.getVersionString();
        JavaSdkVersion version = versionString == null ? null : JdkVersionUtil.getVersion((String)versionString);
        return version != null && version.getMaxLanguageLevel().isAtLeast(level);
    }

    @Nullable
    private static Sdk getRelevantJdk(@NotNull Project project2, @NotNull Module module2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/projectRoots/ex/JavaSdkUtil", "getRelevantJdk"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/projectRoots/ex/JavaSdkUtil", "getRelevantJdk"));
        }
        Sdk projectJdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        Sdk moduleJdk = ModuleRootManager.getInstance((Module)module2).getSdk();
        return moduleJdk == null ? projectJdk : moduleJdk;
    }
}

