/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrderRootsCache {
    private final Map<CacheKey, VirtualFilePointerContainer> myRoots;
    private final Disposable myParentDisposable;

    public OrderRootsCache(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/roots/impl/OrderRootsCache", "<init>"));
        }
        this.myRoots = ContainerUtil.newConcurrentMap();
        this.myParentDisposable = parentDisposable;
    }

    public VirtualFilePointerContainer setCachedRoots(OrderRootType rootType, int flags, Collection<String> urls) {
        VirtualFilePointerContainer container = VirtualFilePointerManager.getInstance().createContainer(this.myParentDisposable);
        for (String url : urls) {
            container.add(url);
        }
        this.myRoots.put(new CacheKey(rootType, flags), container);
        return container;
    }

    @Nullable
    public VirtualFile[] getCachedRoots(OrderRootType rootType, int flags) {
        VirtualFilePointerContainer cached = this.myRoots.get(new CacheKey(rootType, flags));
        return cached == null ? null : cached.getFiles();
    }

    @Nullable
    public String[] getCachedUrls(OrderRootType rootType, int flags) {
        VirtualFilePointerContainer cached = this.myRoots.get(new CacheKey(rootType, flags));
        return cached != null ? cached.getUrls() : null;
    }

    public void clearCache() {
        for (VirtualFilePointerContainer container : this.myRoots.values()) {
            container.killAll();
        }
        this.myRoots.clear();
    }

    private static final class CacheKey {
        private final OrderRootType myRootType;
        private final int myFlags;

        private CacheKey(OrderRootType rootType, int flags) {
            this.myRootType = rootType;
            this.myFlags = flags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.myFlags == cacheKey.myFlags && this.myRootType.equals((Object)cacheKey.myRootType);
        }

        public int hashCode() {
            return 31 * this.myRootType.hashCode() + this.myFlags;
        }
    }
}

