/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectFileIndexFacade
extends FileIndexFacade {
    private final DirectoryIndex myDirectoryIndex;
    private final ProjectFileIndex myFileIndex;

    public ProjectFileIndexFacade(Project project2, ProjectRootManager rootManager, DirectoryIndex directoryIndex) {
        super(project2);
        this.myDirectoryIndex = directoryIndex;
        this.myFileIndex = rootManager.getFileIndex();
    }

    public boolean isInContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isInContent"));
        }
        return this.myFileIndex.isInContent(file2);
    }

    public boolean isInSource(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isInSource"));
        }
        return this.myFileIndex.isInSource(file2);
    }

    public boolean isInSourceContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isInSourceContent"));
        }
        return this.myFileIndex.isInSourceContent(file2);
    }

    public boolean isInLibraryClasses(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isInLibraryClasses"));
        }
        return this.myFileIndex.isInLibraryClasses(file2);
    }

    public boolean isInLibrarySource(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isInLibrarySource"));
        }
        return this.myFileIndex.isInLibrarySource(file2);
    }

    public boolean isExcludedFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isExcludedFile"));
        }
        return this.myFileIndex.isExcluded(file2);
    }

    public boolean isUnderIgnored(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isUnderIgnored"));
        }
        return this.myFileIndex.isUnderIgnored(file2);
    }

    @Nullable
    public Module getModuleForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "getModuleForFile"));
        }
        return this.myFileIndex.getModuleForFile(file2);
    }

    public boolean isValidAncestor(@NotNull VirtualFile baseDir, @NotNull VirtualFile childDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isValidAncestor"));
        }
        if (childDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childDir", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "isValidAncestor"));
        }
        if (!childDir.isDirectory()) {
            childDir = childDir.getParent();
        }
        while (childDir != null) {
            if (childDir.equals(baseDir)) {
                return true;
            }
            if (!this.myDirectoryIndex.getInfoForFile(childDir).isInProject()) {
                return false;
            }
            childDir = childDir.getParent();
        }
        return false;
    }

    @NotNull
    public ModificationTracker getRootModificationTracker() {
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        if (projectRootManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/ProjectFileIndexFacade", "getRootModificationTracker"));
        }
        return projectRootManager;
    }
}

