/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.impl.TypeSafeDataProviderAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorContextImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorListener;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorSettings;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactPropertiesEditors;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactValidationManagerImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactsStructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.artifacts.ComplexElementSubstitutionParameters;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.ToggleShowElementContentAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.AddCompositeElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.AddNewPackagingElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.ExtractArtifactAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.HideContentAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.InlineArtifactAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.LayoutTreeFindUsagesAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.LayoutTreeNavigateAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.MovePackagingElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.RemovePackagingElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.RenamePackagingElementAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.ShowAddPackagingElementPopupAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.SortElementsToggleAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.SurroundElementWithAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.LibrarySourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.ModuleOutputSourceItem;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTree;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArchivePackagingElement;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactEditorImpl
implements ArtifactEditorEx {
    private JPanel myMainPanel;
    private JCheckBox myBuildOnMakeCheckBox;
    private TextFieldWithBrowseButton myOutputDirectoryField;
    private JPanel myEditorPanel;
    private JPanel myErrorPanelPlace;
    private ThreeStateCheckBox myShowContentCheckBox;
    private FixedSizeButton myShowSpecificContentOptionsButton;
    private JPanel myTopPanel;
    private final ActionGroup myShowSpecificContentOptionsGroup;
    private final Project myProject;
    private final ComplexElementSubstitutionParameters mySubstitutionParameters;
    private final EventDispatcher<ArtifactEditorListener> myDispatcher;
    private final ArtifactEditorContextImpl myContext;
    private final SourceItemsTree mySourceItemsTree;
    private final Artifact myOriginalArtifact;
    private final LayoutTreeComponent myLayoutTreeComponent;
    private TabbedPaneWrapper myTabbedPane;
    private ArtifactPropertiesEditors myPropertiesEditors;
    private final ArtifactValidationManagerImpl myValidationManager;
    private boolean myDisposed;

    public ArtifactEditorImpl(@NotNull ArtifactsStructureConfigurableContext context, @NotNull Artifact artifact, @NotNull ArtifactEditorSettings settings) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "<init>"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "<init>"));
        }
        this.$$$setupUI$$$();
        this.mySubstitutionParameters = new ComplexElementSubstitutionParameters();
        this.myDispatcher = EventDispatcher.create(ArtifactEditorListener.class);
        this.myContext = this.createArtifactEditorContext(context);
        this.myOriginalArtifact = artifact;
        this.myProject = context.getProject();
        this.mySubstitutionParameters.setTypesToShowContent(settings.getTypesToShowContent());
        this.mySourceItemsTree = new SourceItemsTree(this.myContext, this);
        this.myLayoutTreeComponent = new LayoutTreeComponent(this, this.mySubstitutionParameters, this.myContext, this.myOriginalArtifact, settings.isSortElements());
        this.myPropertiesEditors = new ArtifactPropertiesEditors(this.myContext, this.myOriginalArtifact, this.myOriginalArtifact);
        Disposer.register((Disposable)this, (Disposable)this.mySourceItemsTree);
        Disposer.register((Disposable)this, (Disposable)this.myLayoutTreeComponent);
        this.myTopPanel.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.myBuildOnMakeCheckBox.setSelected(artifact.isBuildOnMake());
        String outputPath = artifact.getOutputPath();
        this.myOutputDirectoryField.addBrowseFolderListener(CompilerBundle.message((String)"dialog.title.output.directory.for.artifact", (Object[])new Object[0]), CompilerBundle.message((String)"chooser.description.select.output.directory.for.0.artifact", (Object[])new Object[]{this.getArtifact().getName()}), this.myProject, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myShowSpecificContentOptionsGroup = this.createShowSpecificContentOptionsGroup();
        this.myShowSpecificContentOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionManager.getInstance().createActionPopupMenu("unknown", ArtifactEditorImpl.this.myShowSpecificContentOptionsGroup).getComponent().show((Component)ArtifactEditorImpl.this.myShowSpecificContentOptionsButton, 0, 0);
            }
        });
        this.setOutputPath(outputPath);
        this.myValidationManager = new ArtifactValidationManagerImpl(this);
        this.updateShowContentCheckbox();
    }

    protected ArtifactEditorContextImpl createArtifactEditorContext(ArtifactsStructureConfigurableContext parentContext) {
        return new ArtifactEditorContextImpl(parentContext, this);
    }

    private ActionGroup createShowSpecificContentOptionsGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        for (ComplexPackagingElementType type : PackagingElementFactory.getInstance().getComplexElementTypes()) {
            group.add((AnAction)new ToggleShowElementContentAction(type, this));
        }
        return group;
    }

    private void setOutputPath(@Nullable String outputPath) {
        this.myOutputDirectoryField.setText(outputPath != null ? FileUtil.toSystemDependentName((String)outputPath) : null);
    }

    public void apply() {
        ModifiableArtifact modifiableArtifact = this.myContext.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(this.myOriginalArtifact);
        modifiableArtifact.setBuildOnMake(this.myBuildOnMakeCheckBox.isSelected());
        modifiableArtifact.setOutputPath(this.getConfiguredOutputPath());
        this.myPropertiesEditors.applyProperties();
        this.myLayoutTreeComponent.saveElementProperties();
    }

    @Nullable
    private String getConfiguredOutputPath() {
        String outputPath = FileUtil.toSystemIndependentName((String)this.myOutputDirectoryField.getText().trim());
        if (outputPath.length() == 0) {
            outputPath = null;
        }
        return outputPath;
    }

    public SourceItemsTree getSourceItemsTree() {
        return this.mySourceItemsTree;
    }

    public void addListener(@NotNull ArtifactEditorListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "addListener"));
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    public ArtifactEditorContextImpl getContext() {
        return this.myContext;
    }

    public void removeListener(@NotNull ArtifactEditorListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "removeListener"));
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    @Override
    public Artifact getArtifact() {
        return this.myContext.getArtifactModel().getArtifactByOriginal(this.myOriginalArtifact);
    }

    @Override
    public CompositePackagingElement<?> getRootElement() {
        return this.myLayoutTreeComponent.getRootElement();
    }

    @Override
    public void rebuildTries() {
        this.myLayoutTreeComponent.rebuildTree();
        this.mySourceItemsTree.rebuildTree();
    }

    @Override
    public void queueValidation() {
        this.myContext.queueValidation();
    }

    public JComponent createMainComponent() {
        this.mySourceItemsTree.initTree();
        this.myLayoutTreeComponent.initTree();
        DataManager.registerDataProvider((JComponent)this.myMainPanel, (DataProvider)new TypeSafeDataProviderAdapter(new MyDataProvider()));
        this.myErrorPanelPlace.add((Component)this.myValidationManager.getMainErrorPanel(), "Center");
        OnePixelSplitter splitter = new OnePixelSplitter(false);
        JPanel leftPanel = new JPanel(new BorderLayout());
        JPanel treePanel = this.myLayoutTreeComponent.getTreePanel();
        if (UIUtil.isUnderDarcula()) {
            treePanel.setBorder(new EmptyBorder(3, 0, 0, 0));
        } else {
            treePanel.setBorder(new LineBorder(UIUtil.getBorderColor()));
        }
        leftPanel.add((Component)treePanel, "Center");
        if (UIUtil.isUnderDarcula()) {
            CompoundBorder border = new CompoundBorder((Border)new CustomLineBorder(0, 0, 0, 1), BorderFactory.createEmptyBorder(0, 0, 0, 0));
            leftPanel.setBorder(border);
        } else {
            leftPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 0));
        }
        splitter.setFirstComponent((JComponent)leftPanel);
        JPanel rightPanel = new JPanel(new BorderLayout());
        JPanel rightTopPanel = new JPanel(new BorderLayout());
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 0));
        labelPanel.add(new JLabel("Available Elements "));
        final HyperlinkLabel link = new HyperlinkLabel("");
        link.setIcon(AllIcons.General.Help_small);
        link.setUseIconAsLink(true);
        link.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                JLabel label = new JLabel(ProjectBundle.message((String)"artifact.source.items.tree.tooltip", (Object[])new Object[0]));
                label.setBorder(HintUtil.createHintBorder());
                label.setBackground(HintUtil.INFORMATION_COLOR);
                label.setOpaque(true);
                HintManager.getInstance().showHint((JComponent)label, RelativePoint.getSouthWestOf((JComponent)link), 10, -1);
            }
        });
        labelPanel.add((Component)link);
        rightTopPanel.add((Component)labelPanel, "Center");
        rightPanel.add((Component)rightTopPanel, "North");
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.mySourceItemsTree), (boolean)true);
        JPanel scrollPaneWrap = new JPanel(new BorderLayout());
        scrollPaneWrap.add((Component)scrollPane, "Center");
        if (UIUtil.isUnderDarcula()) {
            scrollPaneWrap.setBorder(new EmptyBorder(3, 0, 0, 0));
        } else {
            scrollPaneWrap.setBorder(new LineBorder(UIUtil.getBorderColor()));
        }
        rightPanel.add((Component)scrollPaneWrap, "Center");
        if (UIUtil.isUnderDarcula()) {
            rightPanel.setBorder(new CompoundBorder((Border)new CustomLineBorder(0, 1, 0, 0), BorderFactory.createEmptyBorder(0, 0, 0, 0)));
        } else {
            rightPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 3));
        }
        splitter.setSecondComponent((JComponent)rightPanel);
        splitter.getDivider().setBackground(UIUtil.getPanelBackground());
        treePanel.setBorder((Border)JBUI.Borders.empty());
        rightPanel.setBorder((Border)JBUI.Borders.empty());
        scrollPaneWrap.setBorder((Border)JBUI.Borders.empty());
        leftPanel.setBorder((Border)JBUI.Borders.empty());
        this.myShowContentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreeStateCheckBox.State state = ArtifactEditorImpl.this.myShowContentCheckBox.getState();
                if (state == ThreeStateCheckBox.State.SELECTED) {
                    ArtifactEditorImpl.this.mySubstitutionParameters.setSubstituteAll();
                } else if (state == ThreeStateCheckBox.State.NOT_SELECTED) {
                    ArtifactEditorImpl.this.mySubstitutionParameters.setSubstituteNone();
                }
                ArtifactEditorImpl.this.myShowContentCheckBox.setThirdStateEnabled(false);
                ArtifactEditorImpl.this.myLayoutTreeComponent.rebuildTree();
                ArtifactEditorImpl.this.onShowContentSettingsChanged();
            }
        });
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)this.createToolbarActionGroup(), true);
        JComponent toolbarComponent = toolbar.getComponent();
        if (UIUtil.isUnderDarcula()) {
            toolbarComponent.setBorder((Border)new CustomLineBorder(0, 0, 1, 0));
        }
        leftPanel.add((Component)toolbarComponent, "North");
        toolbar.updateActionsImmediately();
        rightTopPanel.setPreferredSize(new Dimension(-1, toolbarComponent.getPreferredSize().height));
        this.myTabbedPane = new TabbedPaneWrapper(this);
        this.myTabbedPane.addTab("Output Layout", (JComponent)splitter);
        this.myPropertiesEditors.addTabs(this.myTabbedPane);
        this.myEditorPanel.add((Component)this.myTabbedPane.getComponent(), "Center");
        LayoutTree tree = this.myLayoutTreeComponent.getLayoutTree();
        new ShowAddPackagingElementPopupAction(this).registerCustomShortcutSet(CommonShortcuts.getNew(), (JComponent)((Object)tree));
        PopupHandler.installPopupHandler((JComponent)((Object)tree), (ActionGroup)this.createPopupActionGroup(), (String)"unknown", (ActionManager)ActionManager.getInstance());
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)tree));
        this.rebuildTries();
        return this.getMainComponent();
    }

    private void onShowContentSettingsChanged() {
        this.myContext.getParent().getDefaultSettings().setTypesToShowContent(this.mySubstitutionParameters.getTypesToSubstitute());
    }

    public void updateShowContentCheckbox() {
        ThreeStateCheckBox.State state = this.mySubstitutionParameters.isAllSubstituted() ? ThreeStateCheckBox.State.SELECTED : (this.mySubstitutionParameters.isNoneSubstituted() ? ThreeStateCheckBox.State.NOT_SELECTED : ThreeStateCheckBox.State.DONT_CARE);
        this.myShowContentCheckBox.setThirdStateEnabled(state == ThreeStateCheckBox.State.DONT_CARE);
        this.myShowContentCheckBox.setState(state);
        this.onShowContentSettingsChanged();
    }

    public ArtifactEditorSettings createSettings() {
        return new ArtifactEditorSettings(this.myLayoutTreeComponent.isSortElements(), this.mySubstitutionParameters.getTypesToSubstitute());
    }

    private DefaultActionGroup createToolbarActionGroup() {
        DefaultActionGroup toolbarActionGroup = new DefaultActionGroup();
        ArrayList<AnAction> createActions = new ArrayList<AnAction>(this.createNewElementActions());
        for (AnAction createAction : createActions) {
            toolbarActionGroup.add(createAction);
        }
        toolbarActionGroup.add((AnAction)new RemovePackagingElementAction(this));
        toolbarActionGroup.add((AnAction)Separator.getInstance());
        toolbarActionGroup.add((AnAction)new SortElementsToggleAction(this.getLayoutTreeComponent()));
        toolbarActionGroup.add((AnAction)new MovePackagingElementAction(this.myLayoutTreeComponent, "Move Up", "", IconUtil.getMoveUpIcon(), -1));
        toolbarActionGroup.add((AnAction)new MovePackagingElementAction(this.myLayoutTreeComponent, "Move Down", "", IconUtil.getMoveDownIcon(), 1));
        return toolbarActionGroup;
    }

    public List<AnAction> createNewElementActions() {
        ArrayList<AnAction> createActions = new ArrayList<AnAction>();
        AddCompositeElementAction.addCompositeCreateActions(createActions, this);
        createActions.add((AnAction)this.createAddNonCompositeElementGroup());
        return createActions;
    }

    private DefaultActionGroup createPopupActionGroup() {
        LayoutTree tree = this.myLayoutTreeComponent.getLayoutTree();
        DefaultActionGroup popupActionGroup = new DefaultActionGroup();
        ArrayList<AnAction> createActions = new ArrayList<AnAction>();
        AddCompositeElementAction.addCompositeCreateActions(createActions, this);
        for (AnAction createAction : createActions) {
            popupActionGroup.add(createAction);
        }
        popupActionGroup.add((AnAction)this.createAddNonCompositeElementGroup());
        RemovePackagingElementAction removeAction = new RemovePackagingElementAction(this);
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)((Object)tree));
        popupActionGroup.add((AnAction)removeAction);
        popupActionGroup.add((AnAction)new ExtractArtifactAction(this));
        popupActionGroup.add((AnAction)new InlineArtifactAction(this));
        popupActionGroup.add((AnAction)new RenamePackagingElementAction(this));
        popupActionGroup.add((AnAction)new SurroundElementWithAction(this));
        popupActionGroup.add((AnAction)Separator.getInstance());
        popupActionGroup.add((AnAction)new HideContentAction(this));
        popupActionGroup.add((AnAction)new LayoutTreeNavigateAction(this.myLayoutTreeComponent));
        popupActionGroup.add((AnAction)new LayoutTreeFindUsagesAction(this.myLayoutTreeComponent, this.myProject, this.myContext.getParent()));
        popupActionGroup.add((AnAction)Separator.getInstance());
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)((Object)tree));
        popupActionGroup.add(actionsManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)tree)));
        popupActionGroup.add(actionsManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)tree)));
        return popupActionGroup;
    }

    @Override
    public ComplexElementSubstitutionParameters getSubstitutionParameters() {
        return this.mySubstitutionParameters;
    }

    private ActionGroup createAddNonCompositeElementGroup() {
        DefaultActionGroup group = new DefaultActionGroup(ProjectBundle.message((String)"artifacts.add.copy.action", (Object[])new Object[0]), true);
        group.getTemplatePresentation().setIcon(IconUtil.getAddIcon());
        for (PackagingElementType type : PackagingElementFactory.getInstance().getNonCompositeElementTypes()) {
            group.add((AnAction)new AddNewPackagingElementAction(type, this));
        }
        return group;
    }

    @Override
    public JComponent getMainComponent() {
        return this.myMainPanel;
    }

    @Override
    public void addNewPackagingElement(@NotNull PackagingElementType<?> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "addNewPackagingElement"));
        }
        this.myLayoutTreeComponent.addNewPackagingElement(type);
        this.mySourceItemsTree.rebuildTree();
    }

    @Override
    public void removeSelectedElements() {
        this.myLayoutTreeComponent.removeSelectedElements();
    }

    @Override
    public void removePackagingElement(@NotNull String pathToParent, @NotNull PackagingElement<?> element) {
        if (pathToParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToParent", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "removePackagingElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "removePackagingElement"));
        }
        this.doReplaceElement(pathToParent, element, null);
    }

    @Override
    public void replacePackagingElement(@NotNull String pathToParent, @NotNull PackagingElement<?> element, @NotNull PackagingElement<?> replacement) {
        if (pathToParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToParent", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "replacePackagingElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "replacePackagingElement"));
        }
        if (replacement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "replacement", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "replacePackagingElement"));
        }
        this.doReplaceElement(pathToParent, element, replacement);
    }

    private void doReplaceElement(@NotNull String pathToParent, @NotNull PackagingElement<?> element, @Nullable PackagingElement replacement) {
        if (pathToParent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToParent", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "doReplaceElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "doReplaceElement"));
        }
        this.myLayoutTreeComponent.editLayout(() -> {
            if (pathToParent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathToParent", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "lambda$doReplaceElement$0"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "lambda$doReplaceElement$0"));
            }
            CompositePackagingElement<?> parent = this.findCompositeElementByPath(pathToParent);
            if (parent == null) {
                return;
            }
            for (PackagingElement child : parent.getChildren()) {
                if (!child.isEqualTo(element)) continue;
                parent.removeChild(child);
                if (replacement == null) break;
                parent.addOrFindChild(replacement);
                break;
            }
        });
        this.myLayoutTreeComponent.rebuildTree();
    }

    @Nullable
    private CompositePackagingElement<?> findCompositeElementByPath(String pathToElement) {
        CompositePackagingElement element = this.getRootElement();
        for (String name : StringUtil.split((String)pathToElement, (String)"/")) {
            if ((element = element.findCompositeChild(name)) != null) continue;
            return null;
        }
        return element;
    }

    public boolean isModified() {
        return this.myBuildOnMakeCheckBox.isSelected() != this.myOriginalArtifact.isBuildOnMake() || !Comparing.equal((String)this.getConfiguredOutputPath(), (String)this.myOriginalArtifact.getOutputPath()) || this.myPropertiesEditors.isModified() || this.myLayoutTreeComponent.isPropertiesModified();
    }

    public void dispose() {
        this.myDisposed = true;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public LayoutTreeComponent getLayoutTreeComponent() {
        return this.myLayoutTreeComponent;
    }

    public void updateOutputPath(@NotNull String oldArtifactName, @NotNull String newArtifactName) {
        CompositePackagingElement<?> root;
        if (oldArtifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldArtifactName", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "updateOutputPath"));
        }
        if (newArtifactName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newArtifactName", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "updateOutputPath"));
        }
        String oldDefaultPath = ArtifactUtil.getDefaultArtifactOutputPath(oldArtifactName, this.myProject);
        if (Comparing.equal((String)oldDefaultPath, (String)this.getConfiguredOutputPath())) {
            this.setOutputPath(ArtifactUtil.getDefaultArtifactOutputPath(newArtifactName, this.myProject));
        }
        if ((root = this.getRootElement()) instanceof ArchivePackagingElement) {
            String oldFileName = ArtifactUtil.suggestArtifactFileName(oldArtifactName);
            String name = ((ArchivePackagingElement)root).getArchiveFileName();
            String fileName = FileUtil.getNameWithoutExtension((String)name);
            String extension = FileUtilRt.getExtension((String)name);
            if (fileName.equals(oldFileName) && extension.length() > 0) {
                this.myLayoutTreeComponent.editLayout(() -> {
                    if (newArtifactName == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newArtifactName", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "lambda$updateOutputPath$1"));
                    }
                    ((ArchivePackagingElement)this.getRootElement()).setArchiveFileName(ArtifactUtil.suggestArtifactFileName(newArtifactName) + "." + extension);
                });
                this.myLayoutTreeComponent.updateRootNode();
            }
        }
    }

    public void updateLayoutTree() {
        this.myLayoutTreeComponent.rebuildTree();
    }

    public void putLibraryIntoDefaultLocation(@NotNull Library library) {
        if (library == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "library", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "putLibraryIntoDefaultLocation"));
        }
        this.myLayoutTreeComponent.putIntoDefaultLocations(Collections.singletonList(new LibrarySourceItem(library)));
    }

    public void putModuleIntoDefaultLocation(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/roots/ui/configuration/artifacts/ArtifactEditorImpl", "putModuleIntoDefaultLocation"));
        }
        this.myLayoutTreeComponent.putIntoDefaultLocations(Collections.singletonList(new ModuleOutputSourceItem(module2)));
    }

    public void addToClasspath(CompositePackagingElement<?> element, List<String> classpath) {
        this.myLayoutTreeComponent.saveElementProperties();
        ManifestFileConfiguration manifest = this.myContext.getManifestFile(element, this.getArtifact().getArtifactType());
        if (manifest == null) {
            VirtualFile file2 = ManifestFileUtil.showDialogAndCreateManifest(this.myContext, element);
            if (file2 == null) {
                return;
            }
            ManifestFileUtil.addManifestFileToLayout(file2.getPath(), this.myContext, element);
            manifest = this.myContext.getManifestFile(element, this.getArtifact().getArtifactType());
        }
        if (manifest != null) {
            manifest.addToClasspath(classpath);
        }
        this.myLayoutTreeComponent.resetElementProperties();
    }

    public void setArtifactType(ArtifactType artifactType) {
        ModifiableArtifact modifiableArtifact = this.myContext.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(this.myOriginalArtifact);
        modifiableArtifact.setArtifactType(artifactType);
        this.myPropertiesEditors.removeTabs(this.myTabbedPane);
        this.myPropertiesEditors = new ArtifactPropertiesEditors(this.myContext, this.myOriginalArtifact, this.getArtifact());
        this.myPropertiesEditors.addTabs(this.myTabbedPane);
        CompositePackagingElement<?> oldRootElement = this.getRootElement();
        CompositePackagingElement newRootElement = artifactType.createRootElement(this.getArtifact().getName());
        ArtifactUtil.copyChildren(oldRootElement, newRootElement, this.myProject);
        this.myLayoutTreeComponent.setRootElement(newRootElement);
    }

    public ArtifactValidationManagerImpl getValidationManager() {
        return this.myValidationManager;
    }

    private void createUIComponents() {
        this.myShowContentCheckBox = new ThreeStateCheckBox();
        this.myShowSpecificContentOptionsButton = new FixedSizeButton(16);
    }

    public String getHelpTopic() {
        int tab = this.myTabbedPane.getSelectedIndex();
        if (tab == 0) {
            return "reference.project.structure.artifacts.output";
        }
        String helpId = this.myPropertiesEditors.getHelpId(this.myTabbedPane.getSelectedTitle());
        return helpId != null ? helpId : "reference.settingsdialog.project.structure.artifacts";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel3;
        JPanel jPanel4;
        this.createUIComponents();
        this.myMainPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myTopPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("label.text.output.directory"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOutputDirectoryField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myBuildOnMakeCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ProjectBundle").getString("checkbox.text.build.on.make"));
        jPanel5.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myEditorPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel2).setEnabled(true);
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myErrorPanelPlace = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        ThreeStateCheckBox threeStateCheckBox = this.myShowContentCheckBox;
        threeStateCheckBox.setText("Show content of elements");
        jPanel6.add((Component)threeStateCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        FixedSizeButton fixedSizeButton = this.myShowSpecificContentOptionsButton;
        jPanel6.add((Component)fixedSizeButton, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private class MyDataProvider
    implements TypeSafeDataProvider {
        private MyDataProvider() {
        }

        public void calcData(DataKey key2, DataSink sink) {
            if (ArtifactEditorEx.ARTIFACTS_EDITOR_KEY.equals((Object)key2)) {
                sink.put(ArtifactEditorEx.ARTIFACTS_EDITOR_KEY, (Object)ArtifactEditorImpl.this);
            }
        }
    }
}

