/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.dnd.AdvancedDnDSource;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.SimpleDnDAwareTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.SourceItemsDraggingObject;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTreeRoot;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.ExtractIntoDefaultLocationAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.PackAndPutIntoDefaultLocationAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.PutSourceItemIntoDefaultLocationAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.PutSourceItemIntoParentAndLinkViaManifestAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.SourceItemFindUsagesAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.SourceItemNavigateAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class SourceItemsTree
extends SimpleDnDAwareTree
implements AdvancedDnDSource,
Disposable {
    private final ArtifactEditorImpl myArtifactsEditor;
    private final SimpleTreeBuilder myBuilder;

    public SourceItemsTree(ArtifactEditorContext editorContext, ArtifactEditorImpl artifactsEditor) {
        this.myArtifactsEditor = artifactsEditor;
        this.myBuilder = new SimpleTreeBuilder((JTree)((Object)this), this.getBuilderModel(), (AbstractTreeStructure)new SourceItemsTreeStructure(editorContext, artifactsEditor), (Comparator)new WeightBasedComparator(true));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        PopupHandler.installPopupHandler((JComponent)((Object)this), (ActionGroup)this.createPopupGroup(), (String)"unknown", (ActionManager)ActionManager.getInstance());
        this.installDnD();
    }

    private void installDnD() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().registerSource((AdvancedDnDSource)this);
        }
    }

    private ActionGroup createPopupGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new PutSourceItemIntoDefaultLocationAction(this, this.myArtifactsEditor));
        group.add((AnAction)new PackAndPutIntoDefaultLocationAction(this, this.myArtifactsEditor));
        group.add((AnAction)new PutSourceItemIntoParentAndLinkViaManifestAction(this, this.myArtifactsEditor));
        group.add((AnAction)new ExtractIntoDefaultLocationAction(this, this.myArtifactsEditor));
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new SourceItemNavigateAction(this));
        group.add((AnAction)new SourceItemFindUsagesAction(this, this.myArtifactsEditor.getContext().getProject(), this.myArtifactsEditor.getContext().getParent()));
        DefaultTreeExpander expander = new DefaultTreeExpander((JTree)((Object)this));
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        group.add((AnAction)Separator.getInstance());
        group.addAction(commonActionsManager.createExpandAllAction((TreeExpander)expander, (JComponent)((Object)this)));
        group.addAction(commonActionsManager.createCollapseAllAction((TreeExpander)expander, (JComponent)((Object)this)));
        return group;
    }

    public void rebuildTree() {
        this.myBuilder.updateFromRoot(true);
    }

    public void initTree() {
        this.myBuilder.initRootNode();
    }

    public void dispose() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().unregisterSource((AdvancedDnDSource)this);
        }
    }

    private DefaultMutableTreeNode[] getSelectedTreeNodes() {
        return (DefaultMutableTreeNode[])this.getSelectedNodes(DefaultMutableTreeNode.class, null);
    }

    public boolean canStartDragging(DnDAction action, Point dragOrigin) {
        return !this.getSelectedItems().isEmpty();
    }

    public DnDDragStartBean startDragging(DnDAction action, Point dragOrigin) {
        List<PackagingSourceItem> items = this.getSelectedItems();
        return new DnDDragStartBean((Object)new SourceItemsDraggingObject(items.toArray(new PackagingSourceItem[items.size()])));
    }

    public List<SourceItemNode> getSelectedSourceItemNodes() {
        ArrayList<SourceItemNode> nodes = new ArrayList<SourceItemNode>();
        for (DefaultMutableTreeNode treeNode : this.getSelectedTreeNodes()) {
            Object userObject = treeNode.getUserObject();
            if (!(userObject instanceof SourceItemNode)) continue;
            nodes.add((SourceItemNode)((Object)userObject));
        }
        return nodes;
    }

    public List<PackagingSourceItem> getSelectedItems() {
        ArrayList<PackagingSourceItem> items = new ArrayList<PackagingSourceItem>();
        for (SourceItemNode node : this.getSelectedSourceItemNodes()) {
            PackagingSourceItem sourceItem = node.getSourceItem();
            if (sourceItem == null || !sourceItem.isProvideElements()) continue;
            items.add(sourceItem);
        }
        return items;
    }

    public Pair<Image, Point> createDraggedImage(DnDAction action, Point dragOrigin) {
        DefaultMutableTreeNode[] nodes = this.getSelectedTreeNodes();
        if (nodes.length == 1) {
            return DnDAwareTree.getDragImage((Tree)this, TreeUtil.getPathFromRoot((TreeNode)nodes[0]), dragOrigin);
        }
        return DnDAwareTree.getDragImage((Tree)this, ProjectBundle.message((String)"drag.n.drop.text.0.packaging.elements", (Object[])new Object[]{nodes.length}), dragOrigin);
    }

    public void dragDropEnd() {
    }

    public void dropActionChanged(int gestureModifiers) {
    }

    private static class SourceItemsTreeStructure
    extends SimpleTreeStructure {
        private final ArtifactEditorContext myEditorContext;
        private final ArtifactEditorImpl myArtifactsEditor;
        private SourceItemsTreeRoot myRoot;

        public SourceItemsTreeStructure(ArtifactEditorContext editorContext, ArtifactEditorImpl artifactsEditor) {
            this.myEditorContext = editorContext;
            this.myArtifactsEditor = artifactsEditor;
        }

        public Object getRootElement() {
            if (this.myRoot == null) {
                this.myRoot = new SourceItemsTreeRoot(this.myEditorContext, this.myArtifactsEditor);
            }
            return this.myRoot;
        }
    }
}

