/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraryEditor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconUtilEx;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryTableTreeContentElement;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.OrderRootTypeElement;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.util.PlatformIcons;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

class ItemElement
extends LibraryTableTreeContentElement<ItemElement> {
    protected final String myUrl;
    private final OrderRootType myRootType;

    public ItemElement(@NotNull OrderRootTypeElement parent, @NotNull String url, @NotNull OrderRootType rootType, boolean isJarDirectory, boolean isValid) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/roots/ui/configuration/libraryEditor/ItemElement", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/roots/ui/configuration/libraryEditor/ItemElement", "<init>"));
        }
        if (rootType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/roots/ui/configuration/libraryEditor/ItemElement", "<init>"));
        }
        super(parent);
        this.myUrl = url;
        this.myName = ItemElement.getPresentablePath(url).replace('/', File.separatorChar);
        this.myColor = ItemElement.getForegroundColor(isValid);
        this.setIcon(ItemElement.getIconForUrl(url, isValid, isJarDirectory));
        this.myRootType = rootType;
    }

    private static Icon getIconForUrl(String url, boolean isValid, boolean isJarDirectory) {
        VirtualFile presentableFile;
        Icon icon = isValid ? ((presentableFile = ItemElement.isJarFileRoot(url) ? LocalFileSystem.getInstance().findFileByPath(ItemElement.getPresentablePath(url)) : VirtualFileManager.getInstance().findFileByUrl(url)) != null && presentableFile.isValid() ? (presentableFile.getFileSystem() instanceof HttpFileSystem ? PlatformIcons.WEB_ICON : (presentableFile.isDirectory() ? (isJarDirectory ? AllIcons.Nodes.JarDirectory : PlatformIcons.DIRECTORY_CLOSED_ICON) : IconUtilEx.getIcon((Object)presentableFile, (int)0, null))) : AllIcons.Nodes.PpInvalid) : AllIcons.Nodes.PpInvalid;
        return icon;
    }

    public static String getPresentablePath(String url) {
        String presentablePath = VirtualFileManager.extractPath((String)url);
        if (ItemElement.isJarFileRoot(url)) {
            presentablePath = presentablePath.substring(0, presentablePath.length() - "!/".length());
        }
        return presentablePath;
    }

    private static boolean isJarFileRoot(String url) {
        return VirtualFileManager.extractPath((String)url).endsWith("!/");
    }

    public OrderRootTypeElement getParent() {
        return (OrderRootTypeElement)this.getParentDescriptor();
    }

    @NotNull
    public OrderRootType getRootType() {
        OrderRootType orderRootType = this.myRootType;
        if (orderRootType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraryEditor/ItemElement", "getRootType"));
        }
        return orderRootType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ItemElement)) {
            return false;
        }
        ItemElement itemElement = (ItemElement)((Object)o);
        if (!this.getParent().equals((Object)itemElement.getParent())) {
            return false;
        }
        if (!this.myRootType.equals((Object)itemElement.myRootType)) {
            return false;
        }
        return this.myUrl.equals(itemElement.myUrl);
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraryEditor/ItemElement", "getUrl"));
        }
        return string;
    }

    public int hashCode() {
        int result2 = this.getParent().hashCode();
        result2 = 29 * result2 + this.myUrl.hashCode();
        result2 = 29 * result2 + this.myRootType.hashCode();
        return result2;
    }
}

