/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.actions.StandardVcsGroup;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.actions.VcsContextWrapper;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class VcsGroupsWrapper
extends DefaultActionGroup
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(VcsGroupsWrapper.class);
    @NotNull
    private final PresentationFactory myPresentationFactory = new PresentationFactory();
    private Collection<StandardVcsGroup> myVcsGroups;

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/VcsGroupsWrapper", "update"));
        }
        if (e.getProject() == null) {
            e.getPresentation().setVisible(false);
        } else {
            if (this.myVcsGroups == null) {
                this.myVcsGroups = VcsGroupsWrapper.collectVcsGroups(e);
            }
            this.updateVcsGroups(e);
        }
    }

    private void updateVcsGroups(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/VcsGroupsWrapper", "updateVcsGroups"));
        }
        Set<String> currentVcses = VcsGroupsWrapper.collectVcses(VcsContextWrapper.createInstanceOn(e));
        if (currentVcses.isEmpty()) {
            e.getPresentation().setVisible(false);
        } else {
            Map<String, StandardVcsGroup> vcsGroupMap = this.myVcsGroups.stream().collect(Collectors.toMap(group -> {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/VcsGroupsWrapper", "lambda$updateVcsGroups$0"));
                }
                return group.getVcsName(e.getProject());
            }, Function.identity()));
            StandardVcsGroup firstVcsGroup = (StandardVcsGroup)vcsGroupMap.get(ContainerUtil.getFirstItem(currentVcses));
            StandardVcsGroup allVcsesGroup = currentVcses.size() == 1 && firstVcsGroup != null ? firstVcsGroup : VcsGroupsWrapper.createAllVcsesGroup(vcsGroupMap, currentVcses);
            this.copyPresentation((AnAction)allVcsesGroup, e.getPresentation());
            this.removeAll();
            this.addAll((ActionGroup)allVcsesGroup);
        }
    }

    private void copyPresentation(@NotNull AnAction sourceAction, @NotNull Presentation target) {
        if (sourceAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceAction", "com/intellij/openapi/vcs/actions/VcsGroupsWrapper", "copyPresentation"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/openapi/vcs/actions/VcsGroupsWrapper", "copyPresentation"));
        }
        Presentation source = this.myPresentationFactory.getPresentation(sourceAction);
        target.setDescription(source.getDescription());
        target.restoreTextWithMnemonic(source);
        target.setVisible(source.isVisible());
        target.setEnabled(source.isEnabled());
    }

    @NotNull
    private static Set<String> collectVcses(@NotNull VcsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/VcsGroupsWrapper", "collectVcses"));
        }
        Set<String> set = context.getSelectedFilesStream().map(file2 -> {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/openapi/vcs/actions/VcsGroupsWrapper", "lambda$collectVcses$1"));
            }
            return ChangesUtil.getVcsForFile((VirtualFile)file2, (Project)context.getProject());
        }).filter(Objects::nonNull).map(AbstractVcs::getName).distinct().limit(ProjectLevelVcsManager.getInstance((Project)context.getProject()).getAllActiveVcss().length).collect(Collectors.toSet());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsGroupsWrapper", "collectVcses"));
        }
        return set;
    }

    @NotNull
    private static Collection<StandardVcsGroup> collectVcsGroups(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/actions/VcsGroupsWrapper", "collectVcsGroups"));
        }
        DefaultActionGroup vcsGroup = (DefaultActionGroup)ActionManager.getInstance().getAction("VcsGroup");
        AnAction[] children2 = vcsGroup.getChildren(e);
        ArrayList result2 = ContainerUtil.newArrayList();
        for (AnAction child : children2) {
            if (!(child instanceof StandardVcsGroup)) {
                LOG.error(MessageFormat.format("Any version control group should extends com.intellij.openapi.vcs.actions.StandardVcsGroup class. GroupId class: {0} group ID: {1}", child.getClass().getName(), ActionManager.getInstance().getId(child)));
                continue;
            }
            result2.add((StandardVcsGroup)child);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsGroupsWrapper", "collectVcsGroups"));
        }
        return arrayList;
    }

    @NotNull
    private static DefaultActionGroup createAllVcsesGroup(@NotNull Map<String, StandardVcsGroup> vcsGroupsMap, @NotNull Set<String> vcses) {
        if (vcsGroupsMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsGroupsMap", "com/intellij/openapi/vcs/actions/VcsGroupsWrapper", "createAllVcsesGroup"));
        }
        if (vcses == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcses", "com/intellij/openapi/vcs/actions/VcsGroupsWrapper", "createAllVcsesGroup"));
        }
        DefaultActionGroup result2 = new DefaultActionGroup(VcsBundle.message((String)"group.name.version.control", (Object[])new Object[0]), true);
        vcsGroupsMap.entrySet().stream().filter(e -> {
            if (vcses == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcses", "com/intellij/openapi/vcs/actions/VcsGroupsWrapper", "lambda$createAllVcsesGroup$2"));
            }
            return vcses.contains(e.getKey());
        }).map(Map.Entry::getValue).forEach(arg_0 -> ((DefaultActionGroup)result2).add(arg_0));
        DefaultActionGroup defaultActionGroup = result2;
        if (defaultActionGroup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/actions/VcsGroupsWrapper", "createAllVcsesGroup"));
        }
        return defaultActionGroup;
    }
}

