/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangeListsWriteOperations;
import com.intellij.openapi.vcs.changes.DelayedNotificator;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.local.AddList;
import com.intellij.openapi.vcs.changes.local.ChangeListCommand;
import com.intellij.openapi.vcs.changes.local.EditComment;
import com.intellij.openapi.vcs.changes.local.EditName;
import com.intellij.openapi.vcs.changes.local.MoveChanges;
import com.intellij.openapi.vcs.changes.local.RemoveList;
import com.intellij.openapi.vcs.changes.local.SetDefault;
import com.intellij.openapi.vcs.changes.local.SetReadOnly;
import com.intellij.util.containers.MultiMap;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Modifier
implements ChangeListsWriteOperations {
    private ChangeListWorker myWorker;
    private boolean myInsideUpdate;
    private final List<ChangeListCommand> myCommandQueue;
    private final DelayedNotificator myNotificator;

    public Modifier(ChangeListWorker worker, DelayedNotificator notificator) {
        this.myWorker = worker;
        this.myNotificator = notificator;
        this.myCommandQueue = new LinkedList<ChangeListCommand>();
    }

    @Override
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment, @Nullable Object data) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/Modifier", "addChangeList"));
        }
        AddList command = new AddList(name, comment, data);
        this.impl(command);
        return command.getNewListCopy();
    }

    @Override
    public String setDefault(String name) {
        SetDefault command = new SetDefault(name);
        this.impl(command);
        return command.getPrevious();
    }

    @Override
    public boolean removeChangeList(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/vcs/changes/Modifier", "removeChangeList"));
        }
        RemoveList command = new RemoveList(name);
        this.impl(command);
        return command.isRemoved();
    }

    @Override
    public MultiMap<LocalChangeList, Change> moveChangesTo(String name, Change[] changes) {
        MoveChanges command = new MoveChanges(name, changes);
        this.impl(command);
        return command.getMovedFrom();
    }

    private void impl(ChangeListCommand command) {
        command.apply(this.myWorker);
        if (this.myInsideUpdate) {
            this.myCommandQueue.add(command);
        } else {
            this.myNotificator.callNotify(command);
        }
    }

    @Override
    public boolean setReadOnly(String name, boolean value) {
        SetReadOnly command = new SetReadOnly(name, value);
        this.impl(command);
        return command.isResult();
    }

    @Override
    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        if (fromName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromName", "com/intellij/openapi/vcs/changes/Modifier", "editName"));
        }
        if (toName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/openapi/vcs/changes/Modifier", "editName"));
        }
        EditName command = new EditName(fromName, toName);
        this.impl(command);
        return command.isResult();
    }

    @Override
    public String editComment(@NotNull String fromName, String newComment) {
        if (fromName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromName", "com/intellij/openapi/vcs/changes/Modifier", "editComment"));
        }
        EditComment command = new EditComment(fromName, newComment);
        this.impl(command);
        return command.getOldComment();
    }

    public boolean isInsideUpdate() {
        return this.myInsideUpdate;
    }

    public void enterUpdate() {
        this.myInsideUpdate = true;
    }

    public void finishUpdate(ChangeListWorker worker) {
        this.exitUpdate();
        this.apply(worker);
        this.clearQueue();
    }

    private void exitUpdate() {
        this.myInsideUpdate = false;
    }

    private void clearQueue() {
        this.myCommandQueue.clear();
    }

    private void apply(ChangeListWorker worker) {
        for (ChangeListCommand command : this.myCommandQueue) {
            command.apply(worker);
            this.myNotificator.callNotify(command);
        }
    }

    public void setWorker(ChangeListWorker worker) {
        this.myWorker = worker;
    }
}

