/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.vcsUtil.VcsUtil;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScheduleForAdditionAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "update"));
        }
        boolean enabled = e.getProject() != null && !VcsUtil.isEmpty(this.getUnversionedFiles(e, e.getProject()));
        e.getPresentation().setEnabled(enabled);
        if ("ActionPlace.VcsQuickListPopupAction".equals(e.getPlace()) || "ChangesViewPopup".equals(e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "actionPerformed"));
        }
        Project project2 = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        List<VirtualFile> unversionedFiles = this.getUnversionedFiles(e, project2).collect(Collectors.toList());
        ScheduleForAdditionAction.addUnversioned(project2, unversionedFiles, (Condition<FileStatus>)((Condition)this::isStatusForAddition), (ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY));
    }

    public static boolean addUnversioned(@NotNull Project project2, @NotNull List<VirtualFile> files, @NotNull Condition<FileStatus> unversionedFileCondition, @Nullable ChangesBrowserBase browser) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "addUnversioned"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "addUnversioned"));
        }
        if (unversionedFileCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unversionedFileCondition", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "addUnversioned"));
        }
        boolean result2 = true;
        if (!files.isEmpty()) {
            FileDocumentManager.getInstance().saveAllDocuments();
            Consumer consumer = browser == null ? null : changes -> {
                if (files == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "lambda$addUnversioned$0"));
                }
                browser.rebuildList();
                browser.getViewer().excludeChanges(files);
                browser.getViewer().includeChanges(changes);
            };
            ChangeListManagerImpl manager = ChangeListManagerImpl.getInstanceImpl(project2);
            LocalChangeList targetChangeList = browser == null ? manager.getDefaultChangeList() : (LocalChangeList)browser.getSelectedChangeList();
            List<VcsException> exceptions = manager.addUnversionedFiles(targetChangeList, files, unversionedFileCondition, (Consumer<List<Change>>)consumer);
            result2 = exceptions.isEmpty();
        }
        return result2;
    }

    @NotNull
    private Stream<VirtualFile> getUnversionedFiles(@NotNull AnActionEvent e, @NotNull Project project2) {
        boolean hasExplicitUnversioned;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "getUnversionedFiles"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "getUnversionedFiles"));
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project2);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project2);
        boolean bl = hasExplicitUnversioned = !VcsUtil.isEmpty((Stream)((Stream)e.getData(ChangesListView.UNVERSIONED_FILES_DATA_KEY)));
        Stream<VirtualFile> stream = hasExplicitUnversioned ? (Stream<VirtualFile>)e.getRequiredData(ChangesListView.UNVERSIONED_FILES_DATA_KEY) : (this.checkVirtualFiles(e) ? VcsUtil.notNullize((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM))).filter(file2 -> this.isFileUnversioned((VirtualFile)file2, vcsManager, fileStatusManager)) : Stream.empty());
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "getUnversionedFiles"));
        }
        return stream;
    }

    private boolean isFileUnversioned(@NotNull VirtualFile file2, @NotNull ProjectLevelVcsManager vcsManager, @NotNull FileStatusManager fileStatusManager) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "isFileUnversioned"));
        }
        if (vcsManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcsManager", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "isFileUnversioned"));
        }
        if (fileStatusManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStatusManager", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "isFileUnversioned"));
        }
        AbstractVcs vcs = vcsManager.getVcsFor(file2);
        return vcs != null && !vcs.areDirectoriesVersionedItems() && file2.isDirectory() || this.isStatusForAddition(fileStatusManager.getStatus(file2));
    }

    protected boolean isStatusForAddition(FileStatus status2) {
        return status2 == FileStatus.UNKNOWN;
    }

    protected boolean checkVirtualFiles(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/actions/ScheduleForAdditionAction", "checkVirtualFiles"));
        }
        return ArrayUtil.isEmpty((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
    }
}

