/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.issueLinks;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.ui.ColoredTreeCellRenderer;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeLinkMouseListener
extends LinkMouseListenerBase {
    private final ColoredTreeCellRenderer myRenderer;
    protected WeakReference<TreeNode> myLastHitNode;

    public TreeLinkMouseListener(ColoredTreeCellRenderer renderer) {
        this.myRenderer = renderer;
    }

    protected void showTooltip(JTree tree, MouseEvent e, HaveTooltip launcher) {
        String newText;
        String text = tree.getToolTipText(e);
        String string = newText = launcher == null ? null : launcher.getTooltip();
        if (!Comparing.equal((String)text, (String)newText)) {
            tree.setToolTipText(newText);
        }
    }

    @Nullable
    protected Object getTagAt(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/issueLinks/TreeLinkMouseListener", "getTagAt"));
        }
        JTree tree = (JTree)e.getSource();
        Object tag = null;
        HaveTooltip haveTooltip = null;
        TreePath path = tree.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            int dx = this.getRendererRelativeX(e, tree, path);
            TreeNode treeNode = (TreeNode)path.getLastPathComponent();
            if (this.myLastHitNode == null || this.myLastHitNode.get() != treeNode) {
                if (this.doCacheLastNode()) {
                    this.myLastHitNode = new WeakReference<TreeNode>(treeNode);
                }
                this.myRenderer.getTreeCellRendererComponent(tree, (Object)treeNode, false, false, treeNode.isLeaf(), tree.getRowForPath(path), false);
            }
            if ((tag = this.myRenderer.getFragmentTagAt(dx)) != null && treeNode instanceof HaveTooltip) {
                haveTooltip = (HaveTooltip)((Object)treeNode);
            }
        }
        this.showTooltip(tree, e, haveTooltip);
        return tag;
    }

    protected int getRendererRelativeX(@NotNull MouseEvent e, @NotNull JTree tree, @NotNull TreePath path) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/vcs/changes/issueLinks/TreeLinkMouseListener", "getRendererRelativeX"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/vcs/changes/issueLinks/TreeLinkMouseListener", "getRendererRelativeX"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/issueLinks/TreeLinkMouseListener", "getRendererRelativeX"));
        }
        Rectangle rectangle = tree.getPathBounds(path);
        assert (rectangle != null);
        return e.getX() - rectangle.x;
    }

    protected boolean doCacheLastNode() {
        return true;
    }

    public static interface HaveTooltip {
        public String getTooltip();
    }
}

