/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedBinaryFilePatch
extends FilePatch {
    private final ShelvedBinaryFile myShelvedBinaryFile;

    public ShelvedBinaryFilePatch(@NotNull ShelvedBinaryFile shelvedBinaryFile) {
        if (shelvedBinaryFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "shelvedBinaryFile", "com/intellij/openapi/vcs/changes/shelf/ShelvedBinaryFilePatch", "<init>"));
        }
        this.myShelvedBinaryFile = shelvedBinaryFile;
        this.setBeforeName(this.myShelvedBinaryFile.BEFORE_PATH);
        this.setAfterName(this.myShelvedBinaryFile.AFTER_PATH);
    }

    public static ShelvedBinaryFilePatch patchCopy(@NotNull ShelvedBinaryFilePatch patch) {
        if (patch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "patch", "com/intellij/openapi/vcs/changes/shelf/ShelvedBinaryFilePatch", "patchCopy"));
        }
        return new ShelvedBinaryFilePatch(patch.getShelvedBinaryFile());
    }

    @Nullable
    public String getBeforeFileName() {
        return ShelvedBinaryFilePatch.getFileName(this.myShelvedBinaryFile.BEFORE_PATH);
    }

    @Nullable
    public String getAfterFileName() {
        return ShelvedBinaryFilePatch.getFileName(this.myShelvedBinaryFile.AFTER_PATH);
    }

    @Nullable
    private static String getFileName(String filePath) {
        return filePath != null ? PathUtil.getFileName((String)filePath) : null;
    }

    public boolean isNewFile() {
        return this.myShelvedBinaryFile.BEFORE_PATH == null;
    }

    public boolean isDeletedFile() {
        return this.myShelvedBinaryFile.AFTER_PATH == null;
    }

    @NotNull
    public ShelvedBinaryFile getShelvedBinaryFile() {
        ShelvedBinaryFile shelvedBinaryFile = this.myShelvedBinaryFile;
        if (shelvedBinaryFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/shelf/ShelvedBinaryFilePatch", "getShelvedBinaryFile"));
        }
        return shelvedBinaryFile;
    }
}

