/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.EditSourceAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.pom.Navigatable;
import com.intellij.util.OpenSourceUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;

public class EditSourceForDialogAction
extends EditSourceAction {
    @NotNull
    private final Component mySourceComponent;

    public EditSourceForDialogAction(@NotNull Component component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/vcs/changes/ui/EditSourceForDialogAction", "<init>"));
        }
        Presentation presentation = this.getTemplatePresentation();
        presentation.setText(ActionsBundle.actionText((String)"EditSource"));
        presentation.setIcon(AllIcons.Actions.EditSource);
        presentation.setDescription(ActionsBundle.actionDescription((String)"EditSource"));
        this.mySourceComponent = component;
    }

    @Override
    public void actionPerformed(AnActionEvent e) {
        final Navigatable[] navigatableArray = (Navigatable[])e.getData(CommonDataKeys.NAVIGATABLE_ARRAY);
        if (navigatableArray != null && navigatableArray.length > 0) {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    OpenSourceUtil.navigate((Navigatable[])navigatableArray);
                }
            });
            DialogWrapper dialog = DialogWrapper.findInstance((Component)this.mySourceComponent);
            if (dialog != null && dialog.isModal()) {
                dialog.doCancelAction();
            }
        }
    }
}

