/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex;

import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.util.ArrayUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RangesBuilder {
    private static final Logger LOG = Logger.getInstance(RangesBuilder.class);

    @NotNull
    public static List<Range> createRanges(@NotNull Document current, @NotNull Document vcs) throws FilesTooBigForDiffException {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        List<Range> list = RangesBuilder.createRanges(current, vcs, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        return list;
    }

    @NotNull
    public static List<Range> createRanges(@NotNull Document current, @NotNull Document vcs, boolean innerWhitespaceChanges) throws FilesTooBigForDiffException {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        List<Range> list = RangesBuilder.createRanges(DiffUtil.getLines(current), DiffUtil.getLines(vcs), 0, 0, innerWhitespaceChanges);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        return list;
    }

    @NotNull
    public static List<Range> createRanges(@NotNull List<String> current, @NotNull List<String> vcs, int shift, int vcsShift, boolean innerWhitespaceChanges) throws FilesTooBigForDiffException {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        Diff.Change ch = Diff.buildChanges((Object[])ArrayUtil.toStringArray(vcs), (Object[])ArrayUtil.toStringArray(current));
        ArrayList<Range> result2 = new ArrayList<Range>();
        while (ch != null) {
            if (innerWhitespaceChanges) {
                result2.add(RangesBuilder.createOnSmart(ch, shift, vcsShift, current, vcs));
            } else {
                result2.add(RangesBuilder.createOn(ch, shift, vcsShift));
            }
            ch = ch.link;
        }
        ArrayList<Range> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/RangesBuilder", "createRanges"));
        }
        return arrayList;
    }

    private static Range createOn(@NotNull Diff.Change change, int shift, int vcsShift) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/ex/RangesBuilder", "createOn"));
        }
        int offset1 = shift + change.line1;
        int offset2 = offset1 + change.inserted;
        int uOffset1 = vcsShift + change.line0;
        int uOffset2 = uOffset1 + change.deleted;
        return new Range(offset1, offset2, uOffset1, uOffset2);
    }

    private static Range createOnSmart(@NotNull Diff.Change change, int shift, int vcsShift, @NotNull List<String> current, @NotNull List<String> vcs) throws FilesTooBigForDiffException {
        int innerEnd;
        int innerStart;
        byte innerType;
        int i;
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/ex/RangesBuilder", "createOnSmart"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/openapi/vcs/ex/RangesBuilder", "createOnSmart"));
        }
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/ex/RangesBuilder", "createOnSmart"));
        }
        byte type = RangesBuilder.getChangeType(change);
        int offset1 = shift + change.line1;
        int offset2 = offset1 + change.inserted;
        int uOffset1 = vcsShift + change.line0;
        int uOffset2 = uOffset1 + change.deleted;
        if (type != 1) {
            return new Range(offset1, offset2, uOffset1, uOffset2, Collections.singletonList(new Range.InnerRange(offset1, offset2, type)));
        }
        Object[] lines1 = new LineWrapper[change.deleted];
        Object[] lines2 = new LineWrapper[change.inserted];
        for (i = 0; i < change.deleted; ++i) {
            lines1[i] = new LineWrapper(vcs.get(i + change.line0));
        }
        for (i = 0; i < change.inserted; ++i) {
            lines2[i] = new LineWrapper(current.get(i + change.line1));
        }
        Diff.Change ch = Diff.buildChanges((Object[])lines1, (Object[])lines2);
        ArrayList<Range.InnerRange> inner = new ArrayList<Range.InnerRange>();
        int last0 = 0;
        int last1 = 0;
        while (ch != null) {
            if (ch.line0 != last0 && ch.line1 != last1) {
                innerType = 0;
                innerStart = shift + change.line1 + last1;
                innerEnd = shift + change.line1 + ch.line1;
                inner.add(new Range.InnerRange(innerStart, innerEnd, innerType));
            }
            innerType = RangesBuilder.getChangeType(ch);
            innerStart = shift + change.line1 + ch.line1;
            innerEnd = innerStart + ch.inserted;
            inner.add(new Range.InnerRange(innerStart, innerEnd, innerType));
            last0 = ch.line0 + ch.deleted;
            last1 = ch.line1 + ch.inserted;
            ch = ch.link;
        }
        if (change.deleted != last0 && change.inserted != last1) {
            innerType = 0;
            innerStart = shift + change.line1 + last1;
            innerEnd = shift + change.line1 + change.inserted;
            inner.add(new Range.InnerRange(innerStart, innerEnd, innerType));
        }
        return new Range(offset1, offset2, uOffset1, uOffset2, inner);
    }

    private static byte getChangeType(@NotNull Diff.Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/openapi/vcs/ex/RangesBuilder", "getChangeType"));
        }
        if (change.deleted > 0 && change.inserted > 0) {
            return 1;
        }
        if (change.deleted > 0) {
            return 3;
        }
        if (change.inserted > 0) {
            return 2;
        }
        LOG.error("Unknown change type");
        return 0;
    }

    private static class LineWrapper {
        @NotNull
        private final String myLine;
        private final int myHash;

        public LineWrapper(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/openapi/vcs/ex/RangesBuilder$LineWrapper", "<init>"));
            }
            this.myLine = line;
            this.myHash = StringUtil.stringHashCodeIgnoreWhitespaces((CharSequence)line);
        }

        @NotNull
        public String getLine() {
            String string = this.myLine;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/ex/RangesBuilder$LineWrapper", "getLine"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LineWrapper wrapper = (LineWrapper)o;
            if (this.myHash != wrapper.myHash) {
                return false;
            }
            return StringUtil.equalsIgnoreWhitespaces((CharSequence)this.myLine, (CharSequence)wrapper.myLine);
        }

        public int hashCode() {
            return this.myHash;
        }
    }
}

