/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.impl;

import com.intellij.openapi.vfs.newvfs.impl.MapReference;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.keyFMap.ArrayBackedFMap;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.OneElementFMap;
import com.intellij.util.keyFMap.PairElementsFMap;
import java.lang.ref.Reference;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class UserDataInterner {
    private static final LinkedHashMap<MapReference, MapReference> ourCache = new LinkedHashMap<MapReference, MapReference>(20, true){

        protected boolean removeEldestEntry(Map.Entry<MapReference, MapReference> eldest) {
            return this.size() > 15;
        }
    };

    UserDataInterner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KeyFMap internUserData(@NotNull KeyFMap map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/vfs/newvfs/impl/UserDataInterner", "internUserData"));
        }
        if (UserDataInterner.shouldIntern(map)) {
            MapReference key2 = new MapReference(map);
            LinkedHashMap<MapReference, MapReference> linkedHashMap = ourCache;
            synchronized (linkedHashMap) {
                KeyFMap cached = (KeyFMap)SoftReference.dereference((Reference)((Reference)ourCache.get((Object)key2)));
                if (cached != null) {
                    return cached;
                }
                ourCache.put((Object)key2, (Object)key2);
            }
            return map;
        }
        return map;
    }

    private static boolean shouldIntern(@NotNull KeyFMap map) {
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/vfs/newvfs/impl/UserDataInterner", "shouldIntern"));
        }
        return map instanceof OneElementFMap || map instanceof PairElementsFMap || map instanceof ArrayBackedFMap && ((ArrayBackedFMap)map).getKeyIds().length <= 5;
    }
}

