/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.elements;

import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.elements.ComplexPackagingElementType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.impl.elements.LibraryPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class LibraryElementType
extends ComplexPackagingElementType<LibraryPackagingElement> {
    public static final LibraryElementType LIBRARY_ELEMENT_TYPE = new LibraryElementType();

    LibraryElementType() {
        super("library", CompilerBundle.message((String)"element.type.name.library.files", (Object[])new Object[0]));
    }

    public Icon getCreateElementIcon() {
        return PlatformIcons.LIBRARY_ICON;
    }

    public boolean canCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/LibraryElementType", "canCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/elements/LibraryElementType", "canCreate"));
        }
        return !LibraryElementType.getAllLibraries(context).isEmpty();
    }

    @NotNull
    public List<? extends LibraryPackagingElement> chooseAndCreate(@NotNull ArtifactEditorContext context, @NotNull Artifact artifact, @NotNull CompositePackagingElement<?> parent) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/elements/LibraryElementType", "chooseAndCreate"));
        }
        if (artifact == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifact", "com/intellij/packaging/impl/elements/LibraryElementType", "chooseAndCreate"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/packaging/impl/elements/LibraryElementType", "chooseAndCreate"));
        }
        List selected = context.chooseLibraries(ProjectBundle.message((String)"dialog.title.packaging.choose.library", (Object[])new Object[0]));
        ArrayList<LibraryPackagingElement> elements = new ArrayList<LibraryPackagingElement>();
        for (Library library : selected) {
            elements.add(new LibraryPackagingElement(library.getTable().getTableLevel(), library.getName(), null));
        }
        ArrayList<LibraryPackagingElement> arrayList = elements;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/LibraryElementType", "chooseAndCreate"));
        }
        return arrayList;
    }

    private static List<Library> getAllLibraries(ArtifactEditorContext context) {
        ArrayList<Library> libraries = new ArrayList<Library>();
        ContainerUtil.addAll(libraries, (Object[])LibraryTablesRegistrar.getInstance().getLibraryTable().getLibraries());
        ContainerUtil.addAll(libraries, (Object[])LibraryTablesRegistrar.getInstance().getLibraryTable(context.getProject()).getLibraries());
        return libraries;
    }

    @NotNull
    public LibraryPackagingElement createEmpty(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/elements/LibraryElementType", "createEmpty"));
        }
        LibraryPackagingElement libraryPackagingElement = new LibraryPackagingElement();
        if (libraryPackagingElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/elements/LibraryElementType", "createEmpty"));
        }
        return libraryPackagingElement;
    }

    public String getShowContentActionText() {
        return "Show Library Files";
    }
}

