/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.TemplateModuleBuilder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="template")
public abstract class ArchivedProjectTemplate
implements ProjectTemplate {
    public static final String INPUT_FIELD = "input-field";
    public static final String TEMPLATE = "template";
    public static final String INPUT_DEFAULT = "default";
    protected final String myDisplayName;
    @Nullable
    private final String myCategory;
    private List<WizardInputField> myInputFields;
    private List<String> myFrameworks;
    private List<Artifact> myArtifacts;

    public ArchivedProjectTemplate(@NotNull String displayName, @Nullable String category) {
        if (displayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/platform/templates/ArchivedProjectTemplate", "<init>"));
        }
        this.myInputFields = Collections.emptyList();
        this.myFrameworks = new ArrayList<String>();
        this.myArtifacts = new ArrayList<Artifact>();
        this.myDisplayName = displayName;
        this.myCategory = category;
    }

    @NotNull
    public String getName() {
        String string = this.myDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ArchivedProjectTemplate", "getName"));
        }
        return string;
    }

    public Icon getIcon() {
        return this.getModuleType().getIcon();
    }

    protected abstract ModuleType getModuleType();

    @NotNull
    public ModuleBuilder createModuleBuilder() {
        TemplateModuleBuilder templateModuleBuilder = new TemplateModuleBuilder(this, this.getModuleType(), this.getInputFields());
        if (templateModuleBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ArchivedProjectTemplate", "createModuleBuilder"));
        }
        return templateModuleBuilder;
    }

    @NotNull
    public List<WizardInputField> getInputFields() {
        List<WizardInputField> list = this.myInputFields;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ArchivedProjectTemplate", "getInputFields"));
        }
        return list;
    }

    @Property(surroundWithTag=false)
    @AbstractCollection(elementTag="artifact", surroundWithTag=false)
    public List<Artifact> getArtifacts() {
        return this.myArtifacts;
    }

    public void setArtifacts(List<Artifact> artifacts) {
        this.myArtifacts = artifacts;
    }

    @Property(surroundWithTag=false)
    @AbstractCollection(elementTag="framework", surroundWithTag=false, elementValueAttribute="")
    @NotNull
    public List<String> getFrameworks() {
        List<String> list = this.myFrameworks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ArchivedProjectTemplate", "getFrameworks"));
        }
        return list;
    }

    public void setFrameworks(List<String> frameworks) {
        this.myFrameworks = frameworks;
    }

    @Nullable
    public ValidationInfo validateSettings() {
        return null;
    }

    public abstract <T> T processStream(@NotNull StreamProcessor<T> var1) throws IOException;

    @Nullable
    public String getCategory() {
        return this.myCategory;
    }

    public void populateFromElement(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/platform/templates/ArchivedProjectTemplate", "populateFromElement"));
        }
        XmlSerializer.deserializeInto((Object)this, (Element)element);
        this.myInputFields = ArchivedProjectTemplate.getFields(element);
    }

    private static List<WizardInputField> getFields(Element templateElement) {
        return ContainerUtil.mapNotNull((Collection)templateElement.getChildren(INPUT_FIELD), element -> {
            ProjectTemplateParameterFactory factory = WizardInputField.getFactoryById((String)element.getText());
            return factory == null ? null : factory.createField(element.getAttributeValue(INPUT_DEFAULT));
        });
    }

    static <T> T consumeZipStream(@NotNull StreamProcessor<T> consumer, @NotNull ZipInputStream stream) throws IOException {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/platform/templates/ArchivedProjectTemplate", "consumeZipStream"));
        }
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/platform/templates/ArchivedProjectTemplate", "consumeZipStream"));
        }
        try {
            T t = consumer.consume(stream);
            return t;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    public static abstract class StreamProcessor<T> {
        public abstract T consume(@NotNull ZipInputStream var1) throws IOException;
    }
}

