/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.ApplicationProfileManager;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.ProjectProfileManager;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class ProfilesComboBox
extends JComboBox {
    public static final String USE_GLOBAL_PROFILE = InspectionsBundle.message((String)"profile.project.settings.disable.text", (Object[])new Object[0]);
    private boolean myFrozenProfilesCombo;
    private Condition<ModifiableModel> myUpdateCallback;

    public void setUpdateCallback(Condition<ModifiableModel> updateCallback) {
        this.myUpdateCallback = updateCallback;
    }

    public void createProfilesCombo(Profile selectedProfile, Set<Profile> availableProfiles, final ProfileManager profileManager) {
        this.reloadProfiles(profileManager, availableProfiles, selectedProfile);
        this.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Profile) {
                    Profile profile = (Profile)value;
                    this.setText(profile.getName());
                    this.setIcon(profile.isProjectLevel() ? AllIcons.General.ProjectSettings : AllIcons.General.Settings);
                } else if (value instanceof String) {
                    this.setText((String)value);
                }
                return rendererComponent;
            }
        });
        this.addItemListener(new ItemListener(){
            private Object myDeselectedItem = null;

            @Override
            public void itemStateChanged(@NotNull ItemEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/ProfilesComboBox$2", "itemStateChanged"));
                }
                if (ProfilesComboBox.this.myFrozenProfilesCombo) {
                    return;
                }
                if (1 == e.getStateChange()) {
                    Object item = e.getItem();
                    if (profileManager instanceof ProjectProfileManager && item instanceof Profile && !((Profile)item).isProjectLevel()) {
                        if (Messages.showOkCancelDialog((String)InspectionsBundle.message((String)"inspection.new.profile.ide.to.project.warning.message", (Object[])new Object[0]), (String)InspectionsBundle.message((String)"inspection.new.profile.ide.to.project.warning.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon()) == 0) {
                            String newName = Messages.showInputDialog((String)InspectionsBundle.message((String)"inspection.new.profile.text", (Object[])new Object[0]), (String)InspectionsBundle.message((String)"inspection.new.profile.dialog.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                            Object selectedItem = ProfilesComboBox.this.getSelectedItem();
                            if (!StringUtil.isEmpty((String)newName) && selectedItem instanceof Profile) {
                                if (ArrayUtil.find((Object[])profileManager.getAvailableProfileNames(), (Object)newName) == -1 && ArrayUtil.find((Object[])InspectionProfileManager.getInstance().getAvailableProfileNames(), (Object)newName) == -1) {
                                    ProfilesComboBox.this.saveNewProjectProfile(newName, (Profile)selectedItem, profileManager);
                                    return;
                                }
                                Messages.showErrorDialog((String)InspectionsBundle.message((String)"inspection.unable.to.create.profile.message", (Object[])new Object[]{newName}), (String)InspectionsBundle.message((String)"inspection.unable.to.create.profile.dialog.title", (Object[])new Object[0]));
                            }
                        }
                        ProfilesComboBox.this.setSelectedItem(this.myDeselectedItem);
                    }
                } else {
                    this.myDeselectedItem = e.getItem();
                }
            }
        });
    }

    private void saveNewProjectProfile(String newName, Profile profile, ProfileManager profileManager) {
        InspectionProfileImpl inspectionProfile = new InspectionProfileImpl(newName, InspectionToolRegistrar.getInstance(), profileManager);
        ModifiableModel profileModifiableModel = inspectionProfile.getModifiableModel();
        profileModifiableModel.copyFrom(profile);
        profileModifiableModel.setProjectLevel(true);
        profileModifiableModel.setName(newName);
        ((DefaultComboBoxModel)this.getModel()).addElement(profileModifiableModel);
        this.setSelectedItem(profileModifiableModel);
        if (this.myUpdateCallback != null) {
            this.myUpdateCallback.value((Object)profileModifiableModel);
        }
    }

    public void reloadProfiles(ProfileManager profileManager, Set<Profile> availableProfiles, Profile selectedProfile) {
        this.reloadProfiles(profileManager, true, availableProfiles, selectedProfile);
    }

    public void reloadProfiles(ProfileManager profileManager, boolean noneItemAppearance, Set<Profile> availableProfiles, Profile selectedProfile) {
        this.myFrozenProfilesCombo = true;
        Object oldSelection = this.getSelectedItem();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        model.removeAllElements();
        if (noneItemAppearance && profileManager instanceof ProjectProfileManager) {
            model.addElement(USE_GLOBAL_PROFILE);
        }
        for (Profile profile : availableProfiles) {
            model.addElement(profile);
        }
        if (selectedProfile != null && (!selectedProfile.isProjectLevel() && profileManager instanceof ApplicationProfileManager || selectedProfile.isProjectLevel() && profileManager instanceof ProjectProfileManager)) {
            this.setSelectedItem(selectedProfile);
        } else {
            int index = model.getIndexOf(oldSelection);
            if (index != -1) {
                this.setSelectedIndex(index);
            } else if (model.getSize() > 0) {
                this.setSelectedIndex(0);
            }
        }
        this.myFrozenProfilesCombo = false;
    }
}

