/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java.wrap;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.formatter.java.AbstractJavaBlock;
import com.intellij.psi.formatter.java.wrap.ReservedWrapsProvider;
import com.intellij.psi.formatter.java.wrap.impl.JavaChildBlockWrapFactory;
import com.intellij.psi.formatter.java.wrap.impl.JavaChildWrapArranger;
import org.jetbrains.annotations.Nullable;

public class JavaWrapManager {
    public static final JavaWrapManager INSTANCE = new JavaWrapManager();
    private final JavaChildWrapArranger myChildArranger;
    private final JavaChildBlockWrapFactory myChildBlockFactory;

    public JavaWrapManager() {
        this(new JavaChildWrapArranger(), new JavaChildBlockWrapFactory());
    }

    public JavaWrapManager(JavaChildWrapArranger childWrapArranger, JavaChildBlockWrapFactory childBlockWrapFactory) {
        this.myChildArranger = childWrapArranger;
        this.myChildBlockFactory = childBlockWrapFactory;
    }

    @Nullable
    public Wrap arrangeChildWrap(ASTNode child, ASTNode parent, CommonCodeStyleSettings settings, JavaCodeStyleSettings javaSettings, Wrap suggestedWrap, AbstractJavaBlock reservedWrapsProvider) {
        return this.myChildArranger.arrange(child, parent, settings, javaSettings, suggestedWrap, reservedWrapsProvider);
    }

    @Nullable
    public Wrap createChildBlockWrap(ASTBlock block, CommonCodeStyleSettings settings, ReservedWrapsProvider reservedWrapsProvider) {
        return this.myChildBlockFactory.create(block, settings, reservedWrapsProvider);
    }
}

