/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.java.stubs.index.JavaFieldNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaMethodNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaShortClassNameIndex;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.IdFilter;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiShortNamesCacheImpl
extends PsiShortNamesCache {
    private final PsiManagerEx myManager;

    public PsiShortNamesCacheImpl(PsiManagerEx manager) {
        this.myManager = manager;
    }

    @NotNull
    public PsiFile[] getFilesByName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getFilesByName"));
        }
        PsiFile[] psiFileArray = FilenameIndex.getFilesByName(this.myManager.getProject(), name, GlobalSearchScope.projectScope((Project)this.myManager.getProject()));
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getFilesByName"));
        }
        return psiFileArray;
    }

    @NotNull
    public String[] getAllFileNames() {
        String[] stringArray = FilenameIndex.getAllFilenames(this.myManager.getProject());
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getAllFileNames"));
        }
        return stringArray;
    }

    @NotNull
    public PsiClass[] getClassesByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getClassesByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getClassesByName"));
        }
        Collection<PsiClass> classes = JavaShortClassNameIndex.getInstance().get(name, this.myManager.getProject(), scope);
        if (classes.isEmpty()) {
            if (PsiClass.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getClassesByName"));
            }
            return PsiClass.EMPTY_ARRAY;
        }
        ArrayList<PsiClass> list = new ArrayList<PsiClass>(classes.size());
        THashMap uniqueQName2Classes = new THashMap(classes.size());
        Set hiddenClassesToRemove = null;
        block0: for (PsiClass aClass : classes) {
            VirtualFile vFile = aClass.getContainingFile().getVirtualFile();
            if (!scope.contains(vFile)) continue;
            String qName = aClass.getQualifiedName();
            if (qName != null) {
                SmartList qNamedClasses;
                List previousQNamedClasses = (List)uniqueQName2Classes.get(qName);
                if (previousQNamedClasses != null) {
                    qNamedClasses = new SmartList();
                    for (PsiClass previousClass : previousQNamedClasses) {
                        VirtualFile previousClassVFile = previousClass.getContainingFile().getVirtualFile();
                        int res = scope.compare(previousClassVFile, vFile);
                        if (res > 0) continue block0;
                        if (res < 0) {
                            if (hiddenClassesToRemove == null) {
                                hiddenClassesToRemove = new THashSet();
                            }
                            hiddenClassesToRemove.add(previousClass);
                            qNamedClasses.add(aClass);
                            continue;
                        }
                        qNamedClasses.add(aClass);
                    }
                } else {
                    qNamedClasses = new SmartList((Object)aClass);
                }
                uniqueQName2Classes.put(qName, qNamedClasses);
            }
            list.add(aClass);
        }
        if (hiddenClassesToRemove != null) {
            list.removeAll(hiddenClassesToRemove);
        }
        PsiClass[] psiClassArray = list.toArray(new PsiClass[list.size()]);
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getClassesByName"));
        }
        return psiClassArray;
    }

    @NotNull
    public String[] getAllClassNames() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)JavaShortClassNameIndex.getInstance().getAllKeys(this.myManager.getProject()));
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getAllClassNames"));
        }
        return stringArray;
    }

    public void getAllClassNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getAllClassNames"));
        }
        Processor processor2 = Processors.cancelableCollectProcessor(set);
        this.processAllClassNames((Processor<String>)processor2);
    }

    public boolean processAllClassNames(Processor<String> processor2) {
        return JavaShortClassNameIndex.getInstance().processAllKeys(this.myManager.getProject(), processor2);
    }

    public boolean processAllClassNames(Processor<String> processor2, GlobalSearchScope scope, IdFilter filter) {
        return StubIndex.getInstance().processAllKeys(JavaStubIndexKeys.CLASS_SHORT_NAMES, processor2, scope, filter);
    }

    public boolean processAllMethodNames(Processor<String> processor2, GlobalSearchScope scope, IdFilter filter) {
        return StubIndex.getInstance().processAllKeys(JavaStubIndexKeys.METHODS, processor2, scope, filter);
    }

    public boolean processAllFieldNames(Processor<String> processor2, GlobalSearchScope scope, IdFilter filter) {
        return StubIndex.getInstance().processAllKeys(JavaStubIndexKeys.FIELDS, processor2, scope, filter);
    }

    @NotNull
    public PsiMethod[] getMethodsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getMethodsByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getMethodsByName"));
        }
        Collection methods = StubIndex.getElements(JavaStubIndexKeys.METHODS, (Object)name, (Project)this.myManager.getProject(), (GlobalSearchScope)new JavaSourceFilterScope(scope), PsiMethod.class);
        if (methods.isEmpty()) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getMethodsByName"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        List<PsiMethod> list = this.filterMembers(methods, scope);
        PsiMethod[] psiMethodArray = list.toArray(new PsiMethod[list.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getMethodsByName"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getMethodsByNameIfNotMoreThan"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getMethodsByNameIfNotMoreThan"));
        }
        SmartList methods = new SmartList();
        StubIndex.getInstance().processElements(JavaStubIndexKeys.METHODS, (Object)name, this.myManager.getProject(), scope, PsiMethod.class, (Processor)new CommonProcessors.CollectProcessor<PsiMethod>((Collection)methods, (List)methods, maxCount){
            final /* synthetic */ List val$methods;
            final /* synthetic */ int val$maxCount;
            {
                this.val$methods = list;
                this.val$maxCount = n;
                super(arg0);
            }

            public boolean process(PsiMethod method) {
                return this.val$methods.size() != this.val$maxCount && super.process((Object)method);
            }
        });
        if (methods.isEmpty()) {
            if (PsiMethod.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getMethodsByNameIfNotMoreThan"));
            }
            return PsiMethod.EMPTY_ARRAY;
        }
        List<PsiMethod> list = this.filterMembers((Collection)methods, scope);
        PsiMethod[] psiMethodArray = list.toArray(new PsiMethod[list.size()]);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getMethodsByNameIfNotMoreThan"));
        }
        return psiMethodArray;
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull GlobalSearchScope scope, @NotNull Processor<PsiMethod> processor2) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "processMethodsWithName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "processMethodsWithName"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "processMethodsWithName"));
        }
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.METHODS, (Object)name, this.myManager.getProject(), scope, PsiMethod.class, processor2);
    }

    @NotNull
    public String[] getAllMethodNames() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)JavaMethodNameIndex.getInstance().getAllKeys(this.myManager.getProject()));
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getAllMethodNames"));
        }
        return stringArray;
    }

    public void getAllMethodNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getAllMethodNames"));
        }
        JavaMethodNameIndex.getInstance().processAllKeys(this.myManager.getProject(), Processors.cancelableCollectProcessor(set));
    }

    @NotNull
    public PsiField[] getFieldsByNameIfNotMoreThan(@NotNull String name, @NotNull GlobalSearchScope scope, int maxCount) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getFieldsByNameIfNotMoreThan"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getFieldsByNameIfNotMoreThan"));
        }
        SmartList methods = new SmartList();
        StubIndex.getInstance().processElements(JavaStubIndexKeys.FIELDS, (Object)name, this.myManager.getProject(), scope, PsiField.class, (Processor)new CommonProcessors.CollectProcessor<PsiField>((Collection)methods, (List)methods, maxCount){
            final /* synthetic */ List val$methods;
            final /* synthetic */ int val$maxCount;
            {
                this.val$methods = list;
                this.val$maxCount = n;
                super(arg0);
            }

            public boolean process(PsiField method) {
                return this.val$methods.size() != this.val$maxCount && super.process((Object)method);
            }
        });
        if (methods.isEmpty()) {
            if (PsiField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getFieldsByNameIfNotMoreThan"));
            }
            return PsiField.EMPTY_ARRAY;
        }
        List<PsiField> list = this.filterMembers((Collection)methods, scope);
        PsiField[] psiFieldArray = list.toArray(new PsiField[list.size()]);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getFieldsByNameIfNotMoreThan"));
        }
        return psiFieldArray;
    }

    @NotNull
    public PsiField[] getFieldsByName(@NotNull String name, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getFieldsByName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getFieldsByName"));
        }
        Collection<PsiField> fields = JavaFieldNameIndex.getInstance().get(name, this.myManager.getProject(), scope);
        if (fields.isEmpty()) {
            if (PsiField.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getFieldsByName"));
            }
            return PsiField.EMPTY_ARRAY;
        }
        List<PsiField> list = this.filterMembers(fields, scope);
        PsiField[] psiFieldArray = list.toArray(new PsiField[list.size()]);
        if (psiFieldArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getFieldsByName"));
        }
        return psiFieldArray;
    }

    @NotNull
    public String[] getAllFieldNames() {
        String[] stringArray = ArrayUtil.toStringArray((Collection)JavaFieldNameIndex.getInstance().getAllKeys(this.myManager.getProject()));
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getAllFieldNames"));
        }
        return stringArray;
    }

    public void getAllFieldNames(@NotNull HashSet<String> set) {
        if (set == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "set", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "getAllFieldNames"));
        }
        Processor processor2 = Processors.cancelableCollectProcessor(set);
        JavaFieldNameIndex.getInstance().processAllKeys(this.myManager.getProject(), processor2);
    }

    public boolean processFieldsWithName(@NotNull String name, @NotNull Processor<? super PsiField> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "processFieldsWithName"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "processFieldsWithName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "processFieldsWithName"));
        }
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.FIELDS, (Object)name, this.myManager.getProject(), (GlobalSearchScope)new JavaSourceFilterScope(scope), filter, PsiField.class, processor2);
    }

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "processMethodsWithName"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "processMethodsWithName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "processMethodsWithName"));
        }
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.METHODS, (Object)name, this.myManager.getProject(), (GlobalSearchScope)new JavaSourceFilterScope(scope), filter, PsiMethod.class, processor2);
    }

    public boolean processClassesWithName(@NotNull String name, @NotNull Processor<? super PsiClass> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "processClassesWithName"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "processClassesWithName"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/psi/impl/PsiShortNamesCacheImpl", "processClassesWithName"));
        }
        return StubIndex.getInstance().processElements(JavaStubIndexKeys.CLASS_SHORT_NAMES, (Object)name, this.myManager.getProject(), (GlobalSearchScope)new JavaSourceFilterScope(scope), filter, PsiClass.class, processor2);
    }

    private <T extends PsiMember> List<T> filterMembers(Collection<T> members, GlobalSearchScope scope) {
        ArrayList<PsiMember> result2 = new ArrayList<PsiMember>(members.size());
        THashSet set = new THashSet(members.size(), (TObjectHashingStrategy)new TObjectHashingStrategy<PsiMember>(){

            public int computeHashCode(PsiMember member) {
                int code = 0;
                PsiClass clazz = member.getContainingClass();
                if (clazz != null) {
                    String name = clazz.getName();
                    code = name != null ? (code += name.hashCode()) : (code += clazz.hashCode());
                }
                if (member instanceof PsiMethod) {
                    code += 37 * ((PsiMethod)member).getParameterList().getParametersCount();
                }
                return code;
            }

            public boolean equals(PsiMember object, PsiMember object1) {
                return PsiShortNamesCacheImpl.this.myManager.areElementsEquivalent((PsiElement)object, (PsiElement)object1);
            }
        });
        for (PsiMember member : members) {
            ProgressIndicatorProvider.checkCanceled();
            if (!scope.contains(member.getContainingFile().getVirtualFile()) || !set.add(member)) continue;
            result2.add(member);
        }
        return result2;
    }
}

