/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaOverridingMethodsSearcher
implements QueryExecutor<PsiMethod, OverridingMethodsSearch.SearchParameters> {
    public boolean execute(@NotNull OverridingMethodsSearch.SearchParameters parameters, @NotNull Processor<PsiMethod> consumer) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "execute"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "execute"));
        }
        PsiMethod method = parameters.getMethod();
        Project project2 = (Project)ApplicationManager.getApplication().runReadAction(() -> ((PsiMethod)method).getProject());
        SearchScope searchScope = parameters.getScope();
        if (searchScope instanceof LocalSearchScope) {
            return JavaOverridingMethodsSearcher.processLocalScope((LocalSearchScope)searchScope, method, project2, consumer);
        }
        Iterable<PsiMethod> cached = HighlightingCaches.getInstance((Project)project2).OVERRIDING_METHODS.get(method);
        if (cached == null) {
            cached = JavaOverridingMethodsSearcher.compute(method, project2);
            if (((Boolean)ApplicationManager.getApplication().runReadAction(() -> ((PsiMethod)method).isPhysical())).booleanValue()) {
                HighlightingCaches.getInstance((Project)project2).OVERRIDING_METHODS.put(method, cached);
            }
        }
        for (PsiMethod subMethod : cached) {
            ProgressManager.checkCanceled();
            if (!((Boolean)ApplicationManager.getApplication().runReadAction(() -> PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)subMethod))).booleanValue() || consumer.process((Object)subMethod) && parameters.isCheckDeep()) continue;
            return false;
        }
        return true;
    }

    private static boolean processLocalScope(@NotNull LocalSearchScope searchScope, final @NotNull PsiMethod method, final @NotNull Project project2, final @NotNull Processor<PsiMethod> consumer) {
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "processLocalScope"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "processLocalScope"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "processLocalScope"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "processLocalScope"));
        }
        VirtualFile[] virtualFiles = searchScope.getVirtualFiles();
        final PsiClass methodContainingClass = (PsiClass)ApplicationManager.getApplication().runReadAction(() -> ((PsiMethod)method).getContainingClass());
        if (methodContainingClass == null) {
            return true;
        }
        final boolean[] success = new boolean[]{true};
        for (final VirtualFile virtualFile : virtualFiles) {
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                    if (psiFile != null) {
                        psiFile.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                            public void visitClass(PsiClass candidate) {
                                PsiMethod overridingMethod;
                                ProgressManager.checkCanceled();
                                if (!success[0]) {
                                    return;
                                }
                                PsiMethod psiMethod = overridingMethod = candidate == methodContainingClass ? null : JavaOverridingMethodsSearcher.findOverridingMethod(project2, candidate, method, methodContainingClass);
                                if (overridingMethod != null && !consumer.process(overridingMethod)) {
                                    success[0] = false;
                                } else {
                                    super.visitClass(candidate);
                                }
                            }
                        });
                    }
                }
            });
        }
        return success[0];
    }

    @NotNull
    private static Iterable<PsiMethod> compute(@NotNull PsiMethod method, @NotNull Project project2) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "compute"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "compute"));
        }
        LinkedHashSet<PsiMethod> result2 = new LinkedHashSet<PsiMethod>();
        Application application = ApplicationManager.getApplication();
        PsiClass containingClass = (PsiClass)application.runReadAction(() -> ((PsiMethod)method).getContainingClass());
        assert (containingClass != null);
        Processor inheritorsProcessor = inheritor -> {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "lambda$compute$2"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "lambda$compute$2"));
            }
            PsiMethod found = (PsiMethod)application.runReadAction(() -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "lambda$null$1"));
                }
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "lambda$null$1"));
                }
                return JavaOverridingMethodsSearcher.findOverridingMethod(project2, inheritor, method, containingClass);
            });
            if (found != null) {
                result2.add(found);
            }
            return true;
        };
        GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)project2);
        boolean success = ClassInheritorsSearch.search((PsiClass)containingClass, (SearchScope)allScope, (boolean)true).forEach(inheritorsProcessor);
        assert (success);
        LinkedHashSet<PsiMethod> linkedHashSet = result2;
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "compute"));
        }
        return linkedHashSet;
    }

    @Nullable
    static PsiMethod findOverridingMethod(@NotNull Project project2, @NotNull PsiClass inheritor, @NotNull PsiMethod method, @NotNull PsiClass methodContainingClass) {
        MethodSignature signature;
        PsiMethod derived;
        PsiClass superClass;
        PsiMethod found;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "findOverridingMethod"));
        }
        if (inheritor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inheritor", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "findOverridingMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "findOverridingMethod"));
        }
        if (methodContainingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContainingClass", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "findOverridingMethod"));
        }
        String name = method.getName();
        if (inheritor.findMethodsByName(name, false).length > 0 && (found = MethodSignatureUtil.findMethodBySuperSignature((PsiClass)inheritor, (MethodSignature)JavaOverridingMethodsSearcher.getSuperSignature(inheritor, methodContainingClass, method), (boolean)false)) != null && JavaOverridingMethodsSearcher.isAcceptable(project2, found, inheritor, method, methodContainingClass)) {
            return found;
        }
        if (methodContainingClass.isInterface() && !inheritor.isInterface() && (superClass = inheritor.getSuperClass()) != null && !superClass.isInheritor(methodContainingClass, true) && superClass.findMethodsByName(name, true).length > 0 && (derived = MethodSignatureUtil.findMethodInSuperClassBySignatureInDerived((PsiClass)inheritor, (PsiClass)superClass, (MethodSignature)(signature = JavaOverridingMethodsSearcher.getSuperSignature(inheritor, methodContainingClass, method)), (boolean)true)) != null && JavaOverridingMethodsSearcher.isAcceptable(project2, derived, inheritor, method, methodContainingClass)) {
            return derived;
        }
        return null;
    }

    @NotNull
    private static MethodSignature getSuperSignature(PsiClass inheritor, @NotNull PsiClass parentClass, PsiMethod method) {
        if (parentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentClass", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "getSuperSignature"));
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getMaybeSuperClassSubstitutor((PsiClass)parentClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY, null);
        MethodSignature methodSignature = method.getSignature(substitutor != null ? substitutor : PsiSubstitutor.EMPTY);
        if (methodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "getSuperSignature"));
        }
        return methodSignature;
    }

    private static boolean isAcceptable(@NotNull Project project2, @NotNull PsiMethod found, @NotNull PsiClass foundContainingClass, @NotNull PsiMethod method, @NotNull PsiClass methodContainingClass) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "isAcceptable"));
        }
        if (found == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "found", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "isAcceptable"));
        }
        if (foundContainingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foundContainingClass", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "isAcceptable"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "isAcceptable"));
        }
        if (methodContainingClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodContainingClass", "com/intellij/psi/impl/search/JavaOverridingMethodsSearcher", "isAcceptable"));
        }
        return !found.hasModifierProperty("static") && (!method.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance((Project)project2).arePackagesTheSame((PsiElement)methodContainingClass, (PsiElement)foundContainingClass));
    }
}

