/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml.behavior;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.xml.behavior.DefaultXmlPsiPolicy;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import com.intellij.xml.util.XmlUtil;

public class CDATAOnAnyEncodedPolicy
extends DefaultXmlPsiPolicy {
    @Override
    public ASTNode encodeXmlTextContents(String displayText, PsiElement text) {
        boolean textAlreadyHasCDATA;
        ASTNode firstChild = text.getNode().getFirstChildNode();
        boolean bl = textAlreadyHasCDATA = firstChild != null && firstChild.getElementType() == XmlElementType.XML_CDATA;
        if ((textAlreadyHasCDATA || XmlUtil.toCode(displayText)) && !displayText.isEmpty()) {
            FileElement dummyParent = CDATAOnAnyEncodedPolicy.createCDATAElement(text.getManager(), SharedImplUtil.findCharTableByTree(text.getNode()), displayText);
            return dummyParent.getFirstChildNode();
        }
        return super.encodeXmlTextContents(displayText, text);
    }

    public static FileElement createCDATAElement(PsiManager manager, CharTable charTableByTree, String displayText) {
        FileElement dummyParent = DummyHolderFactory.createHolder(manager, null, charTableByTree).getTreeElement();
        CompositeElement cdata = ASTFactory.composite(XmlElementType.XML_CDATA);
        dummyParent.rawAddChildren(cdata);
        cdata.rawAddChildren(ASTFactory.leaf(XmlTokenType.XML_CDATA_START, "<![CDATA["));
        cdata.rawAddChildren(ASTFactory.leaf(XmlTokenType.XML_DATA_CHARACTERS, dummyParent.getCharTable().intern((CharSequence)displayText)));
        cdata.rawAddChildren(ASTFactory.leaf(XmlTokenType.XML_CDATA_END, "]]>"));
        dummyParent.acceptTree(new GeneratedMarkerVisitor());
        return dummyParent;
    }
}

