/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl.test;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.stubsHierarchy.impl.ClassAnchorUtil;
import com.intellij.psi.stubsHierarchy.impl.HierarchyService;
import com.intellij.psi.stubsHierarchy.impl.SingleClassHierarchy;
import com.intellij.psi.stubsHierarchy.impl.SmartClassAnchor;
import com.intellij.psi.stubsHierarchy.impl.test.InheritanceAction;
import org.jetbrains.annotations.NotNull;

public class TestStubHierarchyAction
extends InheritanceAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubsHierarchy.TestStubHierarchyAction");

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 != null) {
            ProgressManager progress = ProgressManager.getInstance();
            progress.runProcessWithProgressSynchronously((Runnable)new TestHierarchy(project2), "Testing Hierarchy", true, project2);
        }
    }

    private static class TestHierarchy
    implements Runnable {
        private final SingleClassHierarchy symbols;
        Project myProject;

        TestHierarchy(Project project2) {
            this.myProject = project2;
            this.symbols = HierarchyService.instance(this.myProject).getSingleClassHierarchy();
        }

        @Override
        public void run() {
            LOG.info("TestStubHierarchyAction started");
            ProgressManager progressManager = ProgressManager.getInstance();
            ProgressIndicator indicator = progressManager.getProgressIndicator();
            indicator.setText("Getting keys");
            SmartClassAnchor[] classes = this.symbols.myClassAnchors;
            int size = this.symbols.myClassAnchors.length;
            for (int i = 0; i < size; ++i) {
                int finalI = i;
                ApplicationManager.getApplication().runReadAction(() -> this.test(classes[finalI]));
                indicator.setFraction((double)i * 1.0 / (double)size);
            }
            LOG.info("TestStubHierarchyAction finished");
        }

        private void test(SmartClassAnchor aClass) {
            PsiClass psiClass = ClassAnchorUtil.retrieve(this.myProject, aClass);
            if (psiClass == null) {
                LOG.info("error testing: could not retrieve file for anchor: " + aClass);
                return;
            }
            this.test(aClass, psiClass, psiClass.getSuperClass());
            for (PsiClass inter : psiClass.getInterfaces()) {
                this.test(aClass, psiClass, inter);
            }
        }

        private void test(SmartClassAnchor anchor, PsiClass psiClass, PsiClass fromPsi) {
            if (fromPsi == null) {
                return;
            }
            String psiName = fromPsi.getQualifiedName();
            if ("java.lang.Object".equals(psiName) || "groovy.lang.GroovyObject".equals(psiName) || "groovy.lang.GroovyObjectSupport".equals(psiName)) {
                return;
            }
            LOG.info("error testing " + TestHierarchy.classInfo(psiClass) + ": missing " + TestHierarchy.classInfo(fromPsi));
        }

        @NotNull
        private static String classInfo(PsiClass psiClass) {
            String string = psiClass + "[" + psiClass.getQualifiedName() + "] (" + psiClass.getContainingFile().getVirtualFile().getPresentableUrl() + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubsHierarchy/impl/test/TestStubHierarchyAction$TestHierarchy", "classInfo"));
            }
            return string;
        }
    }
}

