/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectIconsAccessor {
    @NonNls
    private static final String JAVAX_SWING_ICON = "javax.swing.Icon";
    private static final int ICON_MAX_WEIGHT = 16;
    private static final int ICON_MAX_HEIGHT = 16;
    private static final int ICON_MAX_SIZE = 0x200000;
    private static final List<String> ICON_EXTENSIONS = ContainerUtil.immutableList((Object[])new String[]{"png", "ico", "bmp", "gif", "jpg"});
    private final Project myProject;
    private final SLRUMap<String, Pair<Long, Icon>> iconsCache = new SLRUMap(500, 1000);

    ProjectIconsAccessor(Project project2) {
        this.myProject = project2;
    }

    public static ProjectIconsAccessor getInstance(Project project2) {
        return (ProjectIconsAccessor)ServiceManager.getService((Project)project2, ProjectIconsAccessor.class);
    }

    @Nullable
    public VirtualFile resolveIconFile(PsiType type, @Nullable PsiExpression initializer) {
        if (initializer == null || !initializer.isValid() || !ProjectIconsAccessor.isIconClassType(type)) {
            return null;
        }
        final ArrayList refs = new ArrayList();
        initializer.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof PsiLiteralExpression) {
                    for (PsiReference ref : element.getReferences()) {
                        if (!(ref instanceof FileReference)) continue;
                        refs.add((FileReference)ref);
                    }
                }
                super.visitElement(element);
            }
        });
        for (FileReference ref : refs) {
            PsiFileSystemItem psiFileSystemItem = ref.resolve();
            VirtualFile file2 = null;
            if (psiFileSystemItem == null) {
                ResolveResult[] results;
                for (ResolveResult result2 : results = ref.multiResolve(false)) {
                    PsiElement element = result2.getElement();
                    if (!(element instanceof PsiBinaryFile)) continue;
                    file2 = ((PsiFile)element).getVirtualFile();
                    break;
                }
            } else {
                file2 = psiFileSystemItem.getVirtualFile();
            }
            if (file2 == null || file2.isDirectory() || !ProjectIconsAccessor.isIconFileExtension(file2.getExtension()) || file2.getLength() > 0x200000L) continue;
            return file2;
        }
        return null;
    }

    @Nullable
    public Icon getIcon(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/util/ProjectIconsAccessor", "getIcon"));
        }
        String path = file2.getPath();
        long stamp = file2.getModificationStamp();
        Pair iconInfo = (Pair)this.iconsCache.get((Object)path);
        if (iconInfo == null || (Long)iconInfo.getFirst() < stamp) {
            try {
                Icon icon = ProjectIconsAccessor.createOrFindBetterIcon(file2, ProjectIconsAccessor.isIdeaProject(this.myProject));
                iconInfo = new Pair((Object)stamp, (Object)(ProjectIconsAccessor.hasProperSize(icon) ? icon : null));
                this.iconsCache.put((Object)file2.getPath(), (Object)iconInfo);
            }
            catch (Exception e) {
                iconInfo = null;
                this.iconsCache.remove((Object)path);
            }
        }
        return iconInfo == null ? null : (Icon)iconInfo.getSecond();
    }

    public static boolean isIconClassType(PsiType type) {
        return InheritanceUtil.isInheritor((PsiType)type, (String)JAVAX_SWING_ICON);
    }

    private static boolean isIconFileExtension(String extension) {
        return extension != null && ICON_EXTENSIONS.contains(extension.toLowerCase(Locale.US));
    }

    private static boolean hasProperSize(Icon icon) {
        return icon.getIconHeight() <= 16 && icon.getIconWidth() <= 16;
    }

    private static boolean isIdeaProject(Project project2) {
        if (project2 == null) {
            return false;
        }
        VirtualFile baseDir = project2.getBaseDir();
        return baseDir != null && (baseDir.findChild("idea.iml") != null || baseDir.findChild("community-main.iml") != null);
    }

    private static Icon createOrFindBetterIcon(VirtualFile file2, boolean useIconLoader) throws IOException {
        if (useIconLoader) {
            return IconLoader.findIcon((URL)new File(file2.getPath()).toURI().toURL());
        }
        return new ImageIcon(file2.contentsToByteArray());
    }
}

