/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractInterface;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.extractInterface.ExtractInterfaceHandler;
import com.intellij.refactoring.extractSuperclass.ExtractSuperBaseProcessor;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.IncorrectOperationException;

public class ExtractInterfaceProcessor
extends ExtractSuperBaseProcessor {
    public ExtractInterfaceProcessor(Project project2, boolean replaceInstanceOf, PsiDirectory targetDirectory, String newClassName, PsiClass aClass, MemberInfo[] memberInfos, DocCommentPolicy javaDocPolicy) {
        super(project2, replaceInstanceOf, targetDirectory, newClassName, aClass, memberInfos, javaDocPolicy);
    }

    @Override
    protected PsiClass extractSuper(String superClassName) throws IncorrectOperationException {
        return ExtractInterfaceHandler.extractInterface(this.myClass.getContainingFile().getContainingDirectory(), this.myClass, superClassName, this.myMemberInfos, this.myJavaDocPolicy);
    }

    @Override
    protected boolean isSuperInheritor(PsiClass aClass) {
        if (!aClass.isInterface()) {
            return this.myClass.isInheritor(aClass, true);
        }
        return this.doesAnyExtractedInterfaceExtends(aClass);
    }

    @Override
    protected boolean isInSuper(PsiElement member) {
        if (member instanceof PsiField) {
            PsiField field = (PsiField)member;
            return this.doMemberInfosContain(field);
        }
        if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            return this.doMemberInfosContain(method);
        }
        return false;
    }
}

