/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.MethodNodeBase;
import com.intellij.refactoring.changeSignature.inCallers.JavaCallerChooser;
import com.intellij.refactoring.changeSignature.inCallers.JavaMethodNode;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteMethodCalleeUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

abstract class SafeDeleteJavaCalleeChooser
extends JavaCallerChooser {
    private final Project myProject;

    public SafeDeleteJavaCalleeChooser(PsiMethod method, Project project2, ArrayList<UsageInfo> result2) {
        super(method, project2, "Select Methods To Cascade Safe Delete", null, (Consumer<Set<PsiMethod>>)((Consumer)methods -> result2.addAll(ContainerUtil.map((Collection)methods, m -> new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)m, (PsiElement)m, true)))));
        this.myProject = project2;
    }

    @Nullable
    static List<PsiMethod> computeCalleesSafeToDelete(final PsiMethod psiMethod) {
        PsiClass containingClass;
        PsiCodeBlock body = psiMethod.getBody();
        if (body != null && (containingClass = psiMethod.getContainingClass()) != null) {
            final java.util.HashSet methodsToCheck = new java.util.HashSet();
            body.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                    super.visitMethodCallExpression(expression);
                    ContainerUtil.addAllNotNull((Collection)methodsToCheck, (Object[])new PsiMethod[]{expression.resolveMethod()});
                }
            });
            return ContainerUtil.filter(methodsToCheck, m -> containingClass.equals(m.getContainingClass()) && !psiMethod.equals(m) && m.findDeepestSuperMethods().length == 0 && ReferencesSearch.search((PsiElement)m).forEach((Processor)new CommonProcessors.CollectProcessor<PsiReference>(){

                public boolean process(PsiReference reference) {
                    PsiElement element = reference.getElement();
                    return PsiTreeUtil.isAncestor((PsiElement)psiMethod, (PsiElement)element, (boolean)true) || PsiTreeUtil.isAncestor((PsiElement)m, (PsiElement)element, (boolean)true);
                }
            }));
        }
        return null;
    }

    protected abstract ArrayList<SafeDeleteMethodCalleeUsageInfo> getTopLevelItems();

    @Override
    protected JavaMethodNode createTreeNode(PsiMethod nodeMethod, HashSet<PsiMethod> callees, Runnable cancelCallback) {
        SafeDeleteJavaMethodNode node = new SafeDeleteJavaMethodNode(nodeMethod, (java.util.HashSet<PsiMethod>)callees, cancelCallback, nodeMethod != null ? nodeMethod.getProject() : this.myProject);
        if (((PsiMethod)this.getTopMethod()).equals(nodeMethod)) {
            node.setEnabled(false);
            node.setChecked(true);
        }
        return node;
    }

    @Override
    protected MethodNodeBase<PsiMethod> getCalleeNode(MethodNodeBase<PsiMethod> node) {
        return node;
    }

    @Override
    protected MethodNodeBase<PsiMethod> getCallerNode(MethodNodeBase<PsiMethod> node) {
        return (MethodNodeBase)((Object)node.getParent());
    }

    private class SafeDeleteJavaMethodNode
    extends JavaMethodNode {
        public SafeDeleteJavaMethodNode(PsiMethod currentMethod, java.util.HashSet<PsiMethod> callees, Runnable cancelCallback, Project project2) {
            super(currentMethod, (Set<PsiMethod>)callees, project2, cancelCallback);
        }

        @Override
        protected MethodNodeBase<PsiMethod> createNode(PsiMethod caller, java.util.HashSet<PsiMethod> callees) {
            return new SafeDeleteJavaMethodNode(caller, callees, this.myCancelCallback, this.myProject);
        }

        @Override
        protected List<PsiMethod> computeCallers() {
            if (((PsiMethod)SafeDeleteJavaCalleeChooser.this.getTopMethod()).equals(this.getMethod())) {
                return ContainerUtil.map(SafeDeleteJavaCalleeChooser.this.getTopLevelItems(), info -> info.getCalledMethod());
            }
            List<PsiMethod> callees = SafeDeleteJavaCalleeChooser.computeCalleesSafeToDelete((PsiMethod)this.getMethod());
            if (callees != null) {
                callees.remove(SafeDeleteJavaCalleeChooser.this.getTopMethod());
                return callees;
            }
            return Collections.emptyList();
        }

        @Override
        protected Condition<PsiMethod> getFilter() {
            return method -> !((PsiMethod)this.myMethod).equals(method);
        }
    }
}

