/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.AllowedApiFilterExtension;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationReplacementUtil;
import com.intellij.refactoring.typeMigration.rules.AtomicConversionRule;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.jetbrains.annotations.NotNull;

public class ConvertFieldToAtomicIntention
extends PsiElementBaseIntentionAction
implements LowPriorityAction {
    private static final Logger LOG = Logger.getInstance((String)("#" + ConvertFieldToAtomicIntention.class.getName()));
    private final Map<PsiType, String> myFromToMap = ContainerUtil.newHashMap();

    public ConvertFieldToAtomicIntention() {
        this.myFromToMap.put((PsiType)PsiType.INT, AtomicInteger.class.getName());
        this.myFromToMap.put((PsiType)PsiType.LONG, AtomicLong.class.getName());
        this.myFromToMap.put((PsiType)PsiType.BOOLEAN, AtomicBoolean.class.getName());
        this.myFromToMap.put((PsiType)PsiType.INT.createArrayType(), AtomicIntegerArray.class.getName());
        this.myFromToMap.put((PsiType)PsiType.LONG.createArrayType(), AtomicLongArray.class.getName());
    }

    @NotNull
    public String getText() {
        if ("Convert to atomic" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToAtomicIntention", "getText"));
        }
        return "Convert to atomic";
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToAtomicIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        String qualifiedName;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToAtomicIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToAtomicIntention", "isAvailable"));
        }
        PsiVariable psiVariable = ConvertFieldToAtomicIntention.getVariable(element);
        if (psiVariable == null || psiVariable instanceof PsiResourceVariable) {
            return false;
        }
        if (psiVariable.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        if (psiVariable.getTypeElement() == null) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)psiVariable)) {
            return false;
        }
        PsiType psiType = psiVariable.getType();
        PsiClass psiTypeClass = PsiUtil.resolveClassInType((PsiType)psiType);
        if (psiTypeClass != null ? (qualifiedName = psiTypeClass.getQualifiedName()) != null && (this.myFromToMap.values().contains(qualifiedName) || qualifiedName.equals(AtomicReference.class.getName()) || qualifiedName.equals(AtomicReferenceArray.class.getName())) : !this.myFromToMap.containsKey(psiType)) {
            return false;
        }
        return AllowedApiFilterExtension.isClassAllowed(AtomicReference.class.getName(), element);
    }

    private static PsiVariable getVariable(PsiElement element) {
        PsiElement parent;
        if (element instanceof PsiIdentifier && ((parent = element.getParent()) instanceof PsiLocalVariable || parent instanceof PsiField)) {
            return (PsiVariable)parent;
        }
        return null;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiTypeParameter[] typeParameters;
        HashMap substitutor;
        PsiClassType toType;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToAtomicIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToAtomicIntention", "invoke"));
        }
        PsiVariable psiVariable = ConvertFieldToAtomicIntention.getVariable(element);
        LOG.assertTrue(psiVariable != null);
        Query refs = ReferencesSearch.search((PsiElement)psiVariable);
        HashSet<PsiElement> elements = new HashSet<PsiElement>();
        elements.add(element);
        for (PsiReference reference : refs) {
            elements.add(reference.getElement());
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(elements)) {
            return;
        }
        psiVariable.normalizeDeclaration();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        PsiType fromType = psiVariable.getType();
        String atomicQualifiedName = this.myFromToMap.get(fromType);
        if (atomicQualifiedName != null) {
            PsiClass atomicClass = psiFacade.findClass(atomicQualifiedName, GlobalSearchScope.allScope((Project)project2));
            if (atomicClass == null) {
                return;
            }
            toType = factory.createType(atomicClass);
        } else if (fromType instanceof PsiArrayType) {
            PsiClass atomicReferenceArrayClass = psiFacade.findClass(AtomicReferenceArray.class.getName(), GlobalSearchScope.allScope((Project)project2));
            if (atomicReferenceArrayClass == null) {
                return;
            }
            substitutor = ContainerUtil.newHashMap();
            typeParameters = atomicReferenceArrayClass.getTypeParameters();
            if (typeParameters.length == 1) {
                PsiType componentType = ((PsiArrayType)fromType).getComponentType();
                if (componentType instanceof PsiPrimitiveType) {
                    componentType = ((PsiPrimitiveType)componentType).getBoxedType(element);
                }
                substitutor.put(typeParameters[0], componentType);
            }
            toType = factory.createType(atomicReferenceArrayClass, factory.createSubstitutor((Map)substitutor));
        } else {
            PsiClass atomicReferenceClass = psiFacade.findClass(AtomicReference.class.getName(), GlobalSearchScope.allScope((Project)project2));
            if (atomicReferenceClass == null) {
                return;
            }
            substitutor = ContainerUtil.newHashMap();
            typeParameters = atomicReferenceClass.getTypeParameters();
            if (typeParameters.length == 1) {
                PsiType type = fromType;
                if (type instanceof PsiPrimitiveType) {
                    type = ((PsiPrimitiveType)fromType).getBoxedType(element);
                }
                substitutor.put(typeParameters[0], type);
            }
            toType = factory.createType(atomicReferenceClass, factory.createSubstitutor((Map)substitutor));
        }
        try {
            for (PsiReference reference : refs) {
                PsiBinaryExpression binary;
                PsiAssignmentExpression assignment;
                IElementType opSign;
                PsiElement psiElement = reference.getElement();
                if (!(psiElement instanceof PsiExpression)) continue;
                PsiElement parent = psiElement.getParent();
                if (parent instanceof PsiExpression && !(parent instanceof PsiReferenceExpression) && !(parent instanceof PsiPolyadicExpression)) {
                    psiElement = parent;
                }
                if (!(psiElement instanceof PsiBinaryExpression) ? psiElement instanceof PsiAssignmentExpression && (opSign = TypeConversionUtil.convertEQtoOperation((IElementType)(assignment = (PsiAssignmentExpression)psiElement).getOperationTokenType())) != null && TypeConversionUtil.isBinaryOperatorApplicable((IElementType)opSign, (PsiExpression)assignment.getLExpression(), (PsiExpression)assignment.getRExpression(), (boolean)true) : TypeConversionUtil.isBinaryOperatorApplicable((IElementType)(binary = (PsiBinaryExpression)psiElement).getOperationTokenType(), (PsiExpression)binary.getLOperand(), (PsiExpression)binary.getROperand(), (boolean)true)) continue;
                TypeConversionDescriptor directConversion = AtomicConversionRule.findDirectConversion(psiElement, (PsiType)toType, fromType);
                if (directConversion == null) continue;
                TypeMigrationReplacementUtil.replaceExpression((PsiExpression)psiElement, project2, directConversion, new TypeEvaluator(null, null));
            }
            PsiExpression initializer = psiVariable.getInitializer();
            if (initializer != null) {
                TypeConversionDescriptor directConversion;
                if (initializer instanceof PsiArrayInitializerExpression) {
                    PsiExpression normalizedExpr = RefactoringUtil.createNewExpressionFromArrayInitializer((PsiArrayInitializerExpression)initializer, psiVariable.getType());
                    initializer = (PsiExpression)initializer.replace((PsiElement)normalizedExpr);
                }
                if ((directConversion = AtomicConversionRule.wrapWithNewExpression((PsiType)toType, fromType, initializer, element)) != null) {
                    TypeMigrationReplacementUtil.replaceExpression(initializer, project2, directConversion, new TypeEvaluator(null, null));
                }
            } else if (!((PsiModifierList)ObjectUtils.assertNotNull((Object)psiVariable.getModifierList())).hasModifierProperty("final")) {
                PsiExpression newInitializer = factory.createExpressionFromText("new " + toType.getCanonicalText() + "()", (PsiElement)psiVariable);
                if (psiVariable instanceof PsiLocalVariable) {
                    ((PsiLocalVariable)psiVariable).setInitializer(newInitializer);
                } else if (psiVariable instanceof PsiField) {
                    ((PsiField)psiVariable).setInitializer(newInitializer);
                }
                JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)psiVariable.getInitializer());
            }
            PsiElement replaced = ((PsiTypeElement)ObjectUtils.assertNotNull((Object)psiVariable.getTypeElement())).replace((PsiElement)factory.createTypeElement((PsiType)toType));
            JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(replaced);
            if (psiVariable instanceof PsiField || CodeStyleSettingsManager.getSettings((Project)project2).GENERATE_FINAL_LOCALS) {
                PsiModifierList modifierList = (PsiModifierList)ObjectUtils.assertNotNull((Object)psiVariable.getModifierList());
                modifierList.setModifierProperty("final", true);
                modifierList.setModifierProperty("volatile", false);
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

