/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ext;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.ext.RemoteCredentialsHandlerBase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantCredentialsHandler
extends RemoteCredentialsHandlerBase<VagrantBasedCredentialsHolder> {
    public static final String VAGRANT_PREFIX = "vagrant://";

    public VagrantCredentialsHandler(VagrantBasedCredentialsHolder credentials) {
        super(credentials);
    }

    @Override
    public String getId() {
        VagrantBasedCredentialsHolder cred = (VagrantBasedCredentialsHolder)this.getCredentials();
        return VAGRANT_PREFIX + cred.getVagrantFolder() + (StringUtil.isNotEmpty((String)cred.getMachineName()) ? "@" + cred.getMachineName() : "");
    }

    @Override
    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/remote/ext/VagrantCredentialsHandler", "save"));
        }
        ((VagrantBasedCredentialsHolder)this.getCredentials()).save(rootElement);
    }

    @Override
    public String getPresentableDetails(String interpreterPath) {
        VagrantBasedCredentialsHolder cred = (VagrantBasedCredentialsHolder)this.getCredentials();
        String pathRelativeToHome = FileUtil.getLocationRelativeToUserHome((String)cred.getVagrantFolder());
        return "Vagrant VM " + (StringUtil.isNotEmpty((String)cred.getMachineName()) ? "'" + cred.getMachineName() + "' " : "") + "at " + (pathRelativeToHome.length() < cred.getVagrantFolder().length() ? pathRelativeToHome : cred.getVagrantFolder()) + " (" + interpreterPath + ")";
    }

    @Override
    public void load(@Nullable Element rootElement) {
        if (rootElement != null) {
            ((VagrantBasedCredentialsHolder)this.getCredentials()).load(rootElement);
        }
    }
}

