/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.slicer.SliceRootNode;
import com.intellij.slicer.SliceTreeBuilder;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

class CanItBeNullAction
extends AnAction {
    private final SliceTreeBuilder myTreeBuilder;
    private static final String TEXT = "Group by leaf expression nullness";

    CanItBeNullAction(@NotNull SliceTreeBuilder treeBuilder) {
        if (treeBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeBuilder", "com/intellij/slicer/CanItBeNullAction", "<init>"));
        }
        super(TEXT, "Determine whether null can flow into this expression", AllIcons.Debugger.Db_disabled_breakpoint_process);
        this.myTreeBuilder = treeBuilder;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setText(TEXT + (this.myTreeBuilder.analysisInProgress ? " (Analysis in progress)" : ""));
        e.getPresentation().setEnabled(this.isAvailable());
    }

    private boolean isAvailable() {
        PsiElement element;
        if (this.myTreeBuilder.analysisInProgress) {
            return false;
        }
        if (!this.myTreeBuilder.dataFlowToThis) {
            return false;
        }
        if (this.myTreeBuilder.splitByLeafExpressions) {
            return false;
        }
        DefaultMutableTreeNode root = this.myTreeBuilder.getRootNode();
        if (root == null) {
            return false;
        }
        SliceRootNode rootNode = (SliceRootNode)root.getUserObject();
        PsiElement psiElement = element = rootNode == null ? null : rootNode.getRootUsage().getUsageInfo().getElement();
        Object type = element instanceof PsiVariable ? ((PsiVariable)element).getType() : (element instanceof PsiExpression ? ((PsiExpression)element).getType() : null);
        return type instanceof PsiClassType || type instanceof PsiArrayType;
    }

    public void actionPerformed(AnActionEvent e) {
        this.myTreeBuilder.switchToLeafNulls();
    }
}

