/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.codeInspection.SuppressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.spellchecker.DocCommentTokenizer;
import com.intellij.spellchecker.LiteralExpressionTokenizer;
import com.intellij.spellchecker.MethodNameTokenizerJava;
import com.intellij.spellchecker.NamedElementTokenizer;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class JavaSpellcheckingStrategy
extends SpellcheckingStrategy {
    private final MethodNameTokenizerJava myMethodNameTokenizer = new MethodNameTokenizerJava();
    private final DocCommentTokenizer myDocCommentTokenizer = new DocCommentTokenizer();
    private final LiteralExpressionTokenizer myLiteralExpressionTokenizer = new LiteralExpressionTokenizer();
    private final NamedElementTokenizer myNamedElementTokenizer = new NamedElementTokenizer();

    @Override
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof PsiMethod) {
            MethodNameTokenizerJava methodNameTokenizerJava = this.myMethodNameTokenizer;
            if (methodNameTokenizerJava == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/JavaSpellcheckingStrategy", "getTokenizer"));
            }
            return methodNameTokenizerJava;
        }
        if (element instanceof PsiDocComment) {
            DocCommentTokenizer docCommentTokenizer = this.myDocCommentTokenizer;
            if (docCommentTokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/JavaSpellcheckingStrategy", "getTokenizer"));
            }
            return docCommentTokenizer;
        }
        if (element instanceof PsiLiteralExpression) {
            if (SuppressManager.isSuppressedInspectionName((PsiLiteralExpression)((PsiLiteralExpression)element))) {
                Tokenizer tokenizer = EMPTY_TOKENIZER;
                if (tokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/JavaSpellcheckingStrategy", "getTokenizer"));
                }
                return tokenizer;
            }
            LiteralExpressionTokenizer literalExpressionTokenizer = this.myLiteralExpressionTokenizer;
            if (literalExpressionTokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/JavaSpellcheckingStrategy", "getTokenizer"));
            }
            return literalExpressionTokenizer;
        }
        if (element instanceof PsiNamedElement) {
            NamedElementTokenizer namedElementTokenizer = this.myNamedElementTokenizer;
            if (namedElementTokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/JavaSpellcheckingStrategy", "getTokenizer"));
            }
            return namedElementTokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/JavaSpellcheckingStrategy", "getTokenizer"));
        }
        return tokenizer;
    }
}

