/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.compiler.CompileContext;
import com.intellij.structuralsearch.impl.matcher.filters.CompositeFilter;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.LiteralWithSubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class GlobalCompilingVisitor {
    @NonNls
    private static final String SUBSTITUTION_PATTERN_STR = "\\b(__\\$_\\w+)\\b";
    private static final Pattern ourSubstitutionPattern = Pattern.compile("\\b(__\\$_\\w+)\\b");
    private static final Set<String> ourReservedWords = new HashSet<String>(Arrays.asList("Modifier", "Instance")){
        {
            for (StructuralSearchProfile profile : (StructuralSearchProfile[])Extensions.getExtensions(StructuralSearchProfile.EP_NAME)) {
                this.addAll(profile.getReservedWords());
            }
        }
    };
    private static final Pattern ourAlternativePattern = Pattern.compile("^\\((.+)\\)$");
    @NonNls
    private static final String WORD_SEARCH_PATTERN_STR = ".*?\\b(.+?)\\b.*?";
    private static final Pattern ourWordSearchPattern = Pattern.compile(".*?\\b(.+?)\\b.*?");
    private CompileContext context;
    private final ArrayList<PsiElement> myLexicalNodes = new ArrayList();
    private int myCodeBlockLevel;
    private static final NodeFilter ourFilter = LexicalNodesFilter.getInstance();

    public static NodeFilter getFilter() {
        return ourFilter;
    }

    public void setHandler(PsiElement element, MatchingHandler handler2) {
        MatchingHandler realHandler = this.context.getPattern().getHandlerSimple(element);
        if (realHandler instanceof SubstitutionHandler) {
            ((SubstitutionHandler)realHandler).setMatchHandler(handler2);
        } else {
            this.context.getPattern().setHandler(element, handler2);
        }
    }

    public final void handle(PsiElement element) {
        if ((!ourFilter.accepts(element) || StructuralSearchUtil.isIdentifier(element)) && this.context.getPattern().isRealTypedVar(element) && this.context.getPattern().getHandlerSimple(element) == null) {
            String name = this.context.getPattern().getTypedVarString(element);
            SubstitutionHandler handler2 = (SubstitutionHandler)this.context.getPattern().getHandler(name);
            if (handler2 == null) {
                return;
            }
            this.context.getPattern().setHandler(element, handler2);
            if (this.context.getOptions().getVariableConstraint(handler2.getName()).isPartOfSearchResults()) {
                handler2.setTarget(true);
                this.context.getPattern().setTargetNode(element);
            }
        }
    }

    public CompileContext getContext() {
        return this.context;
    }

    public int getCodeBlockLevel() {
        return this.myCodeBlockLevel;
    }

    public void setCodeBlockLevel(int codeBlockLevel) {
        this.myCodeBlockLevel = codeBlockLevel;
    }

    static void setFilter(MatchingHandler handler2, NodeFilter filter) {
        if (handler2.getFilter() != null && handler2.getFilter().getClass() != filter.getClass()) {
            handler2.setFilter(new CompositeFilter(filter, handler2.getFilter()));
        } else {
            handler2.setFilter(filter);
        }
    }

    public List<PsiElement> getLexicalNodes() {
        return this.myLexicalNodes;
    }

    public void addLexicalNode(PsiElement node) {
        this.myLexicalNodes.add(node);
    }

    void compile(PsiElement[] elements, CompileContext context) {
        this.myCodeBlockLevel = 0;
        this.context = context;
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(context.getOptions().getFileType());
        assert (profile != null);
        profile.compile(elements, this);
        if (context.getPattern().getStrategy() == null) {
            System.out.println();
        }
    }

    @Nullable
    public MatchingHandler processPatternStringWithFragments(String pattern, OccurenceKind kind) {
        return this.processPatternStringWithFragments(pattern, kind, ourSubstitutionPattern);
    }

    @Nullable
    public MatchingHandler processPatternStringWithFragments(String pattern, OccurenceKind kind, Pattern substitutionPattern) {
        String word;
        String content;
        if (kind == OccurenceKind.LITERAL) {
            content = pattern.substring(1, pattern.length() - 1);
        } else if (kind == OccurenceKind.COMMENT) {
            content = pattern;
        } else {
            return null;
        }
        StringBuilder buf = new StringBuilder(content.length());
        Matcher matcher = substitutionPattern.matcher(content);
        ArrayList<SubstitutionHandler> handlers = null;
        int start = 0;
        boolean hasLiteralContent = false;
        SubstitutionHandler handler2 = null;
        while (matcher.find()) {
            RegExpPredicate predicate;
            if (handlers == null) {
                handlers = new ArrayList<SubstitutionHandler>();
            }
            if ((handler2 = (SubstitutionHandler)this.getContext().getPattern().getHandler(matcher.group(1))) != null) {
                handlers.add(handler2);
            }
            if ((word = content.substring(start, matcher.start())).length() > 0) {
                buf.append(StructuralSearchUtil.shieldSpecialChars(word));
                hasLiteralContent = true;
                this.processTokenizedName(word, false, kind);
            }
            if ((predicate = MatchingHandler.getSimpleRegExpPredicate(handler2)) == null || !predicate.isWholeWords()) {
                buf.append("(.*?)");
            } else {
                buf.append(".*?\\b(").append(predicate.getRegExp()).append(")\\b.*?");
            }
            if (GlobalCompilingVisitor.isSuitablePredicate(predicate, handler2)) {
                this.processTokenizedName(predicate.getRegExp(), false, kind);
            }
            start = matcher.end();
        }
        word = content.substring(start, content.length());
        if (word.length() > 0) {
            hasLiteralContent = true;
            buf.append(StructuralSearchUtil.shieldSpecialChars(word));
            this.processTokenizedName(word, false, kind);
        }
        if (hasLiteralContent) {
            if (kind == OccurenceKind.LITERAL) {
                buf.insert(0, "[\"']");
                buf.append("[\"']");
            }
            buf.append("$");
        }
        if (handlers != null) {
            return hasLiteralContent ? new LiteralWithSubstitutionHandler(buf.toString(), handlers) : handler2;
        }
        return null;
    }

    @Contract(value="null,_ -> false")
    static boolean isSuitablePredicate(RegExpPredicate predicate, SubstitutionHandler handler2) {
        return predicate != null && handler2.getMinOccurs() != 0 && predicate.couldBeOptimized();
    }

    public static void addFilesToSearchForGivenWord(String refname, boolean endTransaction, OccurenceKind kind, CompileContext compileContext) {
        if (!compileContext.getSearchHelper().doOptimizing()) {
            return;
        }
        if (ourReservedWords.contains(refname)) {
            return;
        }
        boolean addedSomething = false;
        if (kind == OccurenceKind.CODE) {
            addedSomething = compileContext.getSearchHelper().addWordToSearchInCode(refname);
        } else if (kind == OccurenceKind.COMMENT) {
            addedSomething = compileContext.getSearchHelper().addWordToSearchInComments(refname);
        } else if (kind == OccurenceKind.LITERAL) {
            addedSomething = compileContext.getSearchHelper().addWordToSearchInLiterals(refname);
        }
        if (addedSomething && endTransaction) {
            compileContext.getSearchHelper().endTransaction();
        }
    }

    public void processTokenizedName(String name, boolean skipComments, OccurenceKind kind) {
        WordTokenizer tokenizer = new WordTokenizer(name);
        Iterator<String> i = tokenizer.iterator();
        while (i.hasNext()) {
            String nextToken = i.next();
            if (skipComments && (nextToken.equals("/*") || nextToken.equals("/**") || nextToken.equals("*/") || nextToken.equals("*") || nextToken.equals("//"))) continue;
            Matcher matcher = ourAlternativePattern.matcher(nextToken);
            if (matcher.matches()) {
                StringTokenizer alternatives = new StringTokenizer(matcher.group(1), "|");
                while (alternatives.hasMoreTokens()) {
                    GlobalCompilingVisitor.addFilesToSearchForGivenWord(alternatives.nextToken(), !alternatives.hasMoreTokens(), kind, this.getContext());
                }
                continue;
            }
            GlobalCompilingVisitor.addFilesToSearchForGivenWord(nextToken, true, kind, this.getContext());
        }
    }

    private static class WordTokenizer {
        private final List<String> myWords = new ArrayList<String>();

        WordTokenizer(String text) {
            StringTokenizer tokenizer = new StringTokenizer(text);
            Matcher matcher = null;
            while (tokenizer.hasMoreTokens()) {
                int i;
                String nextToken = tokenizer.nextToken();
                if (matcher == null) {
                    matcher = ourWordSearchPattern.matcher(nextToken);
                } else {
                    matcher.reset(nextToken);
                }
                nextToken = matcher.matches() ? matcher.group(1) : nextToken;
                int lastWordStart = 0;
                for (i = 0; i < nextToken.length(); ++i) {
                    if (Character.isJavaIdentifierStart(nextToken.charAt(i))) continue;
                    if (i != lastWordStart) {
                        this.myWords.add(nextToken.substring(lastWordStart, i));
                    }
                    lastWordStart = i + 1;
                }
                if (i == lastWordStart) continue;
                this.myWords.add(nextToken.substring(lastWordStart, i));
            }
        }

        Iterator<String> iterator() {
            return this.myWords.iterator();
        }
    }

    public static enum OccurenceKind {
        LITERAL,
        COMMENT,
        CODE;

    }
}

