/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.util;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiFile;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.MatchingProcess;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;
import gnu.trove.THashSet;
import java.util.Set;

public class DuplicateFilteringResultSink
implements MatchResultSink {
    private final MatchResultSink delegate;
    final Set<SmartPsiPointer> duplicates = new THashSet();

    public DuplicateFilteringResultSink(MatchResultSink delegate) {
        this.delegate = delegate;
    }

    @Override
    public void newMatch(MatchResult result2) {
        if (!this.duplicates.add(result2.getMatchRef())) {
            return;
        }
        this.delegate.newMatch(result2);
    }

    @Override
    public void processFile(PsiFile element) {
        this.delegate.processFile(element);
    }

    @Override
    public void setMatchingProcess(MatchingProcess matchingProcess) {
        this.delegate.setMatchingProcess(matchingProcess);
    }

    @Override
    public void matchingFinished() {
        this.duplicates.clear();
        this.delegate.matchingFinished();
    }

    @Override
    public ProgressIndicator getProgressIndicator() {
        return this.delegate.getProgressIndicator();
    }
}

