/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.tools.ToolsBundle;

public class ToolProcessAdapter
extends ProcessAdapter {
    private final Project myProject;
    private final boolean mySynchronizeAfterExecution;
    private final String myName;

    public ToolProcessAdapter(Project project2, boolean synchronizeAfterExecution, String name) {
        this.myProject = project2;
        this.mySynchronizeAfterExecution = synchronizeAfterExecution;
        this.myName = name;
    }

    public void processTerminated(ProcessEvent event) {
        StatusBar statusBar;
        String message = ToolsBundle.message("tools.completed.message", this.myName, event.getExitCode());
        if (this.mySynchronizeAfterExecution) {
            ApplicationManager.getApplication().runReadAction(() -> VirtualFileManager.getInstance().asyncRefresh(() -> {
                StatusBar statusBar;
                if (ProjectManagerEx.getInstanceEx().isProjectOpened(this.myProject) && (statusBar = WindowManager.getInstance().getStatusBar(this.myProject)) != null) {
                    statusBar.setInfo(message);
                }
            }));
        }
        if (ProjectManagerEx.getInstanceEx().isProjectOpened(this.myProject) && (statusBar = WindowManager.getInstance().getStatusBar(this.myProject)) != null) {
            statusBar.setInfo(message);
        }
    }
}

