/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;

public abstract class CardLayoutPanel<K, UI, V extends Component>
extends JComponent
implements Accessible,
Disposable {
    private final IdentityHashMap<K, V> myContent = new IdentityHashMap();
    private volatile boolean myDisposed;
    private K myKey;

    protected abstract UI prepare(K var1);

    protected abstract V create(UI var1);

    protected void dispose(K key2) {
    }

    public void dispose() {
        if (!this.myDisposed) {
            this.myDisposed = true;
            this.removeAll();
        }
    }

    public K getKey() {
        return this.myKey;
    }

    public V getValue(K key2, boolean create) {
        Component value = (Component)this.myContent.get(key2);
        return (V)(create && value == null && !this.myContent.containsKey(key2) ? this.createValue(key2, this.prepare(key2)) : value);
    }

    private V createValue(K key2, UI ui) {
        V value = this.create(ui);
        this.myContent.put(key2, value);
        if (value != null) {
            ((Component)value).setVisible(false);
            this.add((Component)value);
        }
        return value;
    }

    public ActionCallback select(K key2, boolean now) {
        this.myKey = key2;
        ActionCallback callback = new ActionCallback();
        if (now) {
            this.select(callback, key2, this.prepare(key2));
        } else {
            this.selectLater(callback, key2);
        }
        return callback;
    }

    private void select(ActionCallback callback, K key2, UI ui) {
        if (this.myKey != key2) {
            callback.setRejected();
        } else {
            Component value = (Component)this.myContent.get(key2);
            if (value == null && !this.myContent.containsKey(key2)) {
                value = this.createValue(key2, ui);
            }
            for (Component component : this.getComponents()) {
                component.setVisible(component == value);
            }
            callback.setDone();
        }
    }

    private void selectLater(ActionCallback callback, K key2) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!this.myDisposed) {
                UI ui1 = this.prepare(key2);
                ApplicationManager.getApplication().invokeLater(() -> {
                    HeavyProcessLatch.INSTANCE.prioritizeUiActivity();
                    if (!this.myDisposed) {
                        this.select(callback, key2, ui1);
                    } else {
                        callback.setRejected();
                    }
                }, ModalityState.stateForComponent((Component)this));
            } else {
                callback.setRejected();
            }
        });
    }

    @Override
    public void doLayout() {
        Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
        JBInsets.removeFrom((Rectangle)bounds, (Insets)this.getInsets());
        for (Component component : this.getComponents()) {
            component.setBounds(bounds);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        for (Component component : this.getComponents()) {
            if (!component.isVisible()) continue;
            return component.getPreferredSize();
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        for (Component component : this.getComponents()) {
            if (!component.isVisible()) continue;
            return component.getMinimumSize();
        }
        return super.getMinimumSize();
    }

    @Override
    public void remove(int index) {
        super.remove(index);
        Iterator<Map.Entry<K, V>> it = this.myContent.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> entry = it.next();
            Component value = (Component)entry.getValue();
            if (value == null || this == value.getParent()) continue;
            this.dispose(entry.getKey());
            it.remove();
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        for (K key2 : this.myContent.keySet()) {
            this.dispose(key2);
        }
        this.myContent.clear();
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCardLayoutPanel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleCardLayoutPanel
    extends JComponent.AccessibleJComponent {
        protected AccessibleCardLayoutPanel() {
            super(CardLayoutPanel.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

