/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.Patches;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.HashMap;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;

public class KeyStrokeAdapter
implements KeyListener {
    private static final Logger LOG = Logger.getInstance(KeyStrokeAdapter.class);

    @Override
    public void keyTyped(KeyEvent event) {
        this.keyTyped(event, KeyStrokeAdapter.getKeyStroke(event, false));
    }

    protected boolean keyTyped(KeyStroke stroke) {
        return false;
    }

    private void keyTyped(KeyEvent event, KeyStroke stroke) {
        if (stroke != null && this.keyTyped(stroke)) {
            event.consume();
        }
    }

    @Override
    public void keyPressed(KeyEvent event) {
        this.keyPressed(event, KeyStrokeAdapter.getKeyStroke(event, true));
        this.keyPressed(event, KeyStrokeAdapter.getKeyStroke(event, false));
    }

    protected boolean keyPressed(KeyStroke stroke) {
        return false;
    }

    private void keyPressed(KeyEvent event, KeyStroke stroke) {
        if (stroke != null && this.keyPressed(stroke)) {
            event.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
        this.keyReleased(event, KeyStrokeAdapter.getKeyStroke(event, true));
        this.keyReleased(event, KeyStrokeAdapter.getKeyStroke(event, false));
    }

    protected boolean keyReleased(KeyStroke stroke) {
        return false;
    }

    private void keyReleased(KeyEvent event, KeyStroke stroke) {
        if (stroke != null && this.keyReleased(stroke)) {
            event.consume();
        }
    }

    public static KeyStroke getDefaultKeyStroke(KeyEvent event) {
        if (event == null || event.isConsumed()) {
            return null;
        }
        boolean extendedKeyCodeFirst = !SystemInfo.isWindows && !SystemInfo.isMac && event.getModifiers() == 0;
        KeyStroke stroke = KeyStrokeAdapter.getKeyStroke(event, extendedKeyCodeFirst);
        return stroke != null ? stroke : KeyStrokeAdapter.getKeyStroke(event, !extendedKeyCodeFirst);
    }

    public static KeyStroke getKeyStroke(KeyEvent event, boolean extended) {
        if (event != null && !event.isConsumed()) {
            boolean released;
            int id = event.getID();
            if (id == 400) {
                return extended ? null : KeyStrokeAdapter.getKeyStroke(event.getKeyChar(), 0);
            }
            boolean bl = released = id == 402;
            if (released || id == 401) {
                int code = event.getKeyCode();
                if (extended) {
                    if (Registry.is((String)"actionSystem.extendedKeyCode.disabled")) {
                        return null;
                    }
                    code = KeyStrokeAdapter.getExtendedKeyCode(event);
                    if (code == event.getKeyCode()) {
                        return null;
                    }
                }
                return KeyStrokeAdapter.getKeyStroke(code, event.getModifiers(), released);
            }
        }
        return null;
    }

    private static KeyStroke getKeyStroke(char ch, int modifiers) {
        return '\uffff' == ch ? null : KeyStroke.getKeyStroke(Character.valueOf(ch), modifiers);
    }

    private static KeyStroke getKeyStroke(int code, int modifiers, boolean released) {
        return 0 == code ? null : KeyStroke.getKeyStroke(code, modifiers, released);
    }

    private static int getExtendedKeyCode(KeyEvent event) {
        assert (Patches.USE_REFLECTION_TO_ACCESS_JDK7);
        try {
            Method method = KeyEvent.class.getMethod("getExtendedKeyCode", new Class[0]);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return (Integer)method.invoke((Object)event, new Object[0]);
        }
        catch (Exception exception) {
            return event.getKeyCode();
        }
    }

    public static KeyStroke getKeyStroke(String string) {
        if (string != null) {
            StringTokenizer st = new StringTokenizer(string, " ");
            int modifiers = 0;
            boolean typed = false;
            boolean pressed = false;
            boolean released = false;
            int count = st.countTokens();
            for (int i = 1; i <= count; ++i) {
                String token = st.nextToken();
                if (typed) {
                    if (st.hasMoreTokens()) {
                        LOG.error("key stroke declaration has more tokens: " + st.nextToken());
                        return null;
                    }
                    if (token.length() != 1) {
                        LOG.error("unexpected key stroke character: " + token);
                        return null;
                    }
                    return KeyStrokeAdapter.getKeyStroke(token.charAt(0), modifiers);
                }
                String tokenLowerCase = token.toLowerCase(Locale.ENGLISH);
                if (pressed || released || i == count) {
                    if (st.hasMoreTokens()) {
                        LOG.error("key stroke declaration has more tokens: " + st.nextToken());
                        return null;
                    }
                    Integer code = (Integer)LazyVirtualKeys.myNameToCode.get(tokenLowerCase);
                    if (code == null) {
                        try {
                            code = Integer.decode(token);
                        }
                        catch (NumberFormatException exception) {
                            LOG.error("unexpected key stroke code: " + token);
                            return null;
                        }
                    }
                    return KeyStrokeAdapter.getKeyStroke(code, modifiers, released);
                }
                if (tokenLowerCase.equals("typed")) {
                    typed = true;
                    continue;
                }
                if (tokenLowerCase.equals("pressed")) {
                    pressed = true;
                    continue;
                }
                if (tokenLowerCase.equals("released")) {
                    released = true;
                    continue;
                }
                Integer mask = (Integer)LazyModifiers.mapNameToMask.get(tokenLowerCase);
                if (mask == null) {
                    LOG.error("unexpected key stroke modifier: " + token);
                    return null;
                }
                modifiers |= mask.intValue();
            }
            LOG.error("key stroke declaration is not completed");
        }
        return null;
    }

    public static String toString(KeyStroke stroke) {
        if (stroke != null) {
            StringBuilder sb = new StringBuilder();
            int modifiers = stroke.getModifiers();
            KeyStrokeAdapter.append(sb, "shift", modifiers, 64);
            KeyStrokeAdapter.append(sb, "ctrl", modifiers, 128);
            KeyStrokeAdapter.append(sb, "meta", modifiers, 256);
            KeyStrokeAdapter.append(sb, "alt", modifiers, 512);
            KeyStrokeAdapter.append(sb, "altGraph", modifiers, 8192);
            KeyStrokeAdapter.append(sb, "button1", modifiers, 1024);
            KeyStrokeAdapter.append(sb, "button2", modifiers, 2048);
            KeyStrokeAdapter.append(sb, "button3", modifiers, 4096);
            int code = stroke.getKeyCode();
            if (code != 0) {
                KeyStrokeAdapter.append(sb, "released", stroke.isOnKeyRelease());
                String name = (String)LazyVirtualKeys.myCodeToName.get(code);
                if (name == null) {
                    sb.append('#');
                    name = Integer.toHexString(code);
                }
                return sb.append(name).toString();
            }
            char ch = stroke.getKeyChar();
            if (ch != '\uffff') {
                KeyStrokeAdapter.append(sb, "typed", true);
                return sb.append(ch).toString();
            }
            LOG.error("undefined key stroke");
        }
        return null;
    }

    private static void append(StringBuilder sb, String name, int modifiers, int mask) {
        KeyStrokeAdapter.append(sb, name, (modifiers & mask) != 0);
    }

    private static void append(StringBuilder sb, String name, boolean set) {
        if (set) {
            sb.append(name).append(' ');
        }
    }

    private static final class LazyVirtualKeys {
        private static final Map<String, Integer> myNameToCode = new HashMap();
        private static final Map<Integer, String> myCodeToName = new HashMap();

        private LazyVirtualKeys() {
        }

        static {
            try {
                for (Field field : KeyEvent.class.getFields()) {
                    String name = field.getName();
                    if (!name.startsWith("VK_")) continue;
                    name = name.substring(3).toLowerCase(Locale.ENGLISH);
                    int code = field.getInt(KeyEvent.class);
                    myNameToCode.put(name, code);
                    myCodeToName.put(code, name);
                }
            }
            catch (Exception exception) {
                LOG.error((Throwable)exception);
            }
        }
    }

    private static final class LazyModifiers {
        private static final Map<String, Integer> mapNameToMask = new HashMap();

        private LazyModifiers() {
        }

        static {
            mapNameToMask.put("shift", 65);
            mapNameToMask.put("ctrl", 130);
            mapNameToMask.put("control", 130);
            mapNameToMask.put("meta", 260);
            mapNameToMask.put("alt", 520);
            mapNameToMask.put("altgr", 8224);
            mapNameToMask.put("altgraph", 8224);
            mapNameToMask.put("button1", 1024);
            mapNameToMask.put("button2", 2048);
            mapNameToMask.put("button3", 4096);
        }
    }
}

