/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.Cell;
import com.intellij.ui.ColorPicker;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.util.PairFunction;
import com.intellij.util.ui.EmptyIcon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nullable;

public class ShowUIDefaultsAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        UIDefaults defaults = UIManager.getDefaults();
        Enumeration keys = defaults.keys();
        final Object[][] data = new Object[defaults.size()][2];
        int i = 0;
        while (keys.hasMoreElements()) {
            Object key2 = keys.nextElement();
            data[i][0] = key2;
            data[i][1] = defaults.get(key2);
            ++i;
        }
        Arrays.sort(data, (o1, o2) -> StringUtil.naturalCompare((String)o1[0].toString(), (String)o2[0].toString()));
        final Project project2 = ShowUIDefaultsAction.getEventProject((AnActionEvent)e);
        new DialogWrapper(project2){
            public JBTable myTable;
            {
                super(arg0);
                this.setTitle("Edit LaF Defaults");
                this.setModal(false);
                this.init();
            }

            @Nullable
            public JComponent getPreferredFocusedComponent() {
                return this.myTable;
            }

            @Nullable
            protected String getDimensionServiceKey() {
                return project2 == null ? null : "UI.Defaults.Dialog";
            }

            protected JComponent createCenterPanel() {
                JBTable table = new JBTable(new DefaultTableModel(data, new Object[]{"Name", "Value"}){

                    @Override
                    public boolean isCellEditable(int row, int column) {
                        return column == 1 && this.getValueAt(row, column) instanceof Color;
                    }
                }){

                    public boolean editCellAt(int row, int column, EventObject e) {
                        Object color;
                        Color newColor;
                        if (this.isCellEditable(row, column) && e instanceof MouseEvent && (newColor = ColorPicker.showDialog((Component)((Object)this), "Choose Color", (Color)(color = this.getValueAt(row, column)), true, null, true)) != null) {
                            ColorUIResource colorUIResource = new ColorUIResource(newColor);
                            Object key2 = this.getValueAt(row, 0);
                            UIManager.put(key2, colorUIResource);
                            this.setValueAt(colorUIResource, row, column);
                        }
                        return false;
                    }
                };
                table.setDefaultRenderer(Object.class, (TableCellRenderer)new DefaultTableCellRenderer(){

                    @Override
                    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                        JPanel panel = new JPanel(new BorderLayout());
                        JLabel label = new JLabel(value == null ? "" : value.toString());
                        panel.add((Component)label, "Center");
                        if (value instanceof Color) {
                            Color c = (Color)value;
                            label.setText(String.format("[r=%d,g=%d,b=%d] hex=0x%s", c.getRed(), c.getGreen(), c.getBlue(), ColorUtil.toHex((Color)c)));
                            label.setForeground(ColorUtil.isDark((Color)c) ? Color.white : Color.black);
                            panel.setBackground(c);
                            return panel;
                        }
                        if (value instanceof Icon) {
                            try {
                                IconWrap icon = new IconWrap((Icon)value);
                                if (icon.getIconHeight() <= 20) {
                                    label.setIcon(icon);
                                }
                                label.setText(String.format("(%dx%d) %s)", icon.getIconWidth(), icon.getIconHeight(), label.getText()));
                            }
                            catch (Throwable icon) {
                                // empty catch block
                            }
                            return panel;
                        }
                        if (value instanceof Border) {
                            try {
                                Insets i = ((Border)value).getBorderInsets(null);
                                label.setText(String.format("[%d, %d, %d, %d] %s", i.top, i.left, i.bottom, i.right, label.getText()));
                                return panel;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    }
                });
                JBScrollPane pane = new JBScrollPane((Component)table);
                new TableSpeedSearch((JTable)table, (PairFunction<Object, Cell, String>)((PairFunction)(o, cell) -> cell.column == 1 ? null : String.valueOf(o)));
                table.setShowGrid(false);
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)pane, "Center");
                this.myTable = table;
                TableUtil.ensureSelectionExists((JTable)this.myTable);
                return panel;
            }
        }.show();
    }

    private class IconWrap
    implements Icon {
        private final Icon myIcon;

        public IconWrap(Icon icon) {
            this.myIcon = icon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            try {
                this.myIcon.paintIcon(c, g, x, y);
            }
            catch (Exception e) {
                EmptyIcon.ICON_0.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myIcon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myIcon.getIconHeight();
        }
    }
}

