/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.tree.Invoker;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

interface Command<T>
extends Supplier<T>,
Consumer<T> {

    public static final class Processor
    implements Disposable {
        public final Invoker foreground;
        public final Invoker background;

        public Processor(@NotNull @NonNls String name, boolean queueInBackground) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ui/tree/Command$Processor", "<init>"));
            }
            this(new Invoker.EDT(name), queueInBackground ? new Invoker.BackgroundQueue(name) : new Invoker.Background(name));
        }

        public Processor(@NotNull Invoker foreground, @NotNull Invoker background) {
            if (foreground == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foreground", "com/intellij/ui/tree/Command$Processor", "<init>"));
            }
            if (background == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "background", "com/intellij/ui/tree/Command$Processor", "<init>"));
            }
            this.foreground = foreground;
            this.background = background;
        }

        public <T> void consume(Consumer<T> consumer, T value) {
            if (consumer != null) {
                this.foreground.invokeLaterIfNeeded(() -> consumer.accept(value));
            }
        }

        public <T> void process(Command<T> command) {
            if (command != null) {
                this.background.invokeLaterIfNeeded(() -> this.consume(command, command.get()));
            }
        }

        public <T> void process(Supplier<T> supplier, Consumer<T> consumer) {
            if (supplier != null) {
                this.background.invokeLaterIfNeeded(() -> this.consume(consumer, supplier.get()));
            } else {
                this.consume(consumer, null);
            }
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.foreground);
            Disposer.dispose((Disposable)this.background);
        }
    }
}

