/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.openapi.application.ClipboardAnalyzeListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.unscramble.UnscrambleDialog;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class UnscrambleListener
extends ClipboardAnalyzeListener {
    private static final Pattern STACKTRACE_LINE = Pattern.compile("[\t]*at [[_a-zA-Z0-9]+\\.]+[_a-zA-Z$0-9]+\\.[a-zA-Z0-9_]+\\([A-Za-z0-9_]+\\.java:[\\d]+\\)+[ [~]*\\[[a-zA-Z0-9\\.\\:/]\\]]*");

    @Override
    public boolean canHandle(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/unscramble/UnscrambleListener", "canHandle"));
        }
        value = UnscrambleDialog.normalizeText(value);
        int linesCount = 0;
        for (String line : value.split("\n")) {
            if ((line = line.trim()).length() == 0) continue;
            linesCount = STACKTRACE_LINE.matcher(line = StringUtil.trimEnd((String)line, (String)"\r")).matches() ? ++linesCount : 0;
            if (linesCount <= 2) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void handle(@NotNull Project project2, @NotNull String value) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/unscramble/UnscrambleListener", "handle"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/unscramble/UnscrambleListener", "handle"));
        }
        UnscrambleDialog dialog = new UnscrambleDialog(project2);
        dialog.createNormalizeTextAction().actionPerformed(null);
        if (!DumbService.isDumb((Project)project2)) {
            dialog.doOKAction();
        }
    }
}

