/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.rules.DirectoryGroupingRule;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PackageGroupingRule
extends DirectoryGroupingRule {
    public PackageGroupingRule(Project project2) {
        super(project2);
    }

    protected UsageGroup getGroupForFile(@NotNull VirtualFile dir) {
        PsiPackage aPackage;
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/usages/impl/rules/PackageGroupingRule", "getGroupForFile"));
        }
        PsiDirectory psiDirectory = PsiManager.getInstance((Project)this.myProject).findDirectory(dir);
        if (psiDirectory != null && (aPackage = JavaDirectoryService.getInstance().getPackage(psiDirectory)) != null) {
            return new PackageGroup(aPackage);
        }
        return super.getGroupForFile(dir);
    }

    public String getActionTitle() {
        return UsageViewBundle.message((String)"action.group.by.package", (Object[])new Object[0]);
    }

    private class PackageGroup
    implements UsageGroup,
    TypeSafeDataProvider {
        private final PsiPackage myPackage;
        private Icon myIcon;

        private PackageGroup(PsiPackage aPackage) {
            this.myPackage = aPackage;
            this.update();
        }

        public void update() {
            if (this.isValid()) {
                this.myIcon = this.myPackage.getIcon(0);
            }
        }

        public Icon getIcon(boolean isOpen) {
            return this.myIcon;
        }

        @NotNull
        public String getText(UsageView view) {
            String string = this.myPackage.getQualifiedName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/impl/rules/PackageGroupingRule$PackageGroup", "getText"));
            }
            return string;
        }

        public FileStatus getFileStatus() {
            if (!this.isValid()) {
                return null;
            }
            PsiDirectory[] dirs = this.myPackage.getDirectories();
            return dirs.length == 1 ? FileStatusManager.getInstance((Project)PackageGroupingRule.this.myProject).getStatus(dirs[0].getVirtualFile()) : null;
        }

        public boolean isValid() {
            return this.myPackage.isValid();
        }

        public void navigate(boolean focus) throws UnsupportedOperationException {
            this.myPackage.navigate(focus);
        }

        public boolean canNavigate() {
            return this.myPackage.canNavigate();
        }

        public boolean canNavigateToSource() {
            return false;
        }

        public int compareTo(@NotNull UsageGroup usageGroup) {
            if (usageGroup == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageGroup", "com/intellij/usages/impl/rules/PackageGroupingRule$PackageGroup", "compareTo"));
            }
            return this.getText(null).compareToIgnoreCase(usageGroup.getText(null));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PackageGroup)) {
                return false;
            }
            return this.myPackage.equals(((PackageGroup)o).myPackage);
        }

        public int hashCode() {
            return this.myPackage.hashCode();
        }

        public void calcData(DataKey key2, DataSink sink) {
            if (!this.isValid()) {
                return;
            }
            if (CommonDataKeys.PSI_ELEMENT == key2) {
                sink.put(CommonDataKeys.PSI_ELEMENT, (Object)this.myPackage);
            }
        }
    }
}

